from django.db import models


class Kostenstelle(models.Model):
    # id     = models.AutoField(primary_key=True)
    id     = models.IntegerField(primary_key=True, help_text="...")
    parent = models.ForeignKey('self', models.PROTECT, null=True, blank=True)
    name   = models.CharField(max_length=60, blank=True)

    class Meta:
        db_table = 'kostenstelle'


class KalenderEintrag(models.Model):
    id  = models.AutoField(primary_key=True)
    von = models.DateField(verbose_name="\u200Bvon")
    bis = models.DateField(verbose_name="\u200Bbis")
    kst = models.ManyToManyField(Kostenstelle, blank=True)
