from django.contrib.postgres import fields as pg_fields
from django.db import models

from . import PostgreSQLTestCase


class Test30095(PostgreSQLTestCase):

    def test_choices_tuple_range(self):
        class Model(models.Model):
            field = pg_fields.IntegerRangeField(
               choices=(
                    ((1, 50), "1-50"),
                    ((50, 100), "51-100"),
                )
            )

        self.assertEqual(Model._meta.get_field('field').check(), [])
