from django.contrib import admin

from .models import Choice, Question


class ChoiceInline(admin.TabularInline):
    model = Choice
    extra = 3
    exclude = ("votes",)


class QuestionAdmin(admin.ModelAdmin):
    fieldsets = [
        (None, {"fields": ["question_text"]}),
        ("Date information", {"fields": ["pub_date"]})
    ]
    inlines = [ChoiceInline]
    list_display = ("question_text", "pub_date", "was_published_recently")
    list_editable = ("pub_date",)
    list_filter = ["pub_date"]
    search_fields = ["question_text"]

    def has_change_permission(self, request, obj=None):
        if obj is not None:
            return obj.pk == 1
        return super().has_change_permission(request, obj)


admin.site.register(Question, QuestionAdmin)
