--
-- PostgreSQL database dump
--

-- Dumped from database version 9.6.10
-- Dumped by pg_dump version 9.6.10

-- Started on 2018-12-13 08:22:46 CET

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET client_min_messages = warning;
SET row_security = off;

--
-- TOC entry 7 (class 2615 OID 25453)
-- Name: django_test; Type: SCHEMA; Schema: -; Owner: django_test
--

CREATE SCHEMA django_test;


ALTER SCHEMA django_test OWNER TO django_test;

--
-- TOC entry 1 (class 3079 OID 12393)
-- Name: plpgsql; Type: EXTENSION; Schema: -; Owner: 
--

CREATE EXTENSION IF NOT EXISTS plpgsql WITH SCHEMA pg_catalog;


--
-- TOC entry 2293 (class 0 OID 0)
-- Dependencies: 1
-- Name: EXTENSION plpgsql; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION plpgsql IS 'PL/pgSQL procedural language';


SET default_tablespace = '';

SET default_with_oids = false;

--
-- TOC entry 192 (class 1259 OID 25485)
-- Name: auth_group; Type: TABLE; Schema: django_test; Owner: django_test
--

CREATE TABLE django_test.auth_group (
    id integer NOT NULL,
    name character varying(80) NOT NULL
);


ALTER TABLE django_test.auth_group OWNER TO django_test;

--
-- TOC entry 191 (class 1259 OID 25483)
-- Name: auth_group_id_seq; Type: SEQUENCE; Schema: django_test; Owner: django_test
--

CREATE SEQUENCE django_test.auth_group_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE django_test.auth_group_id_seq OWNER TO django_test;

--
-- TOC entry 2294 (class 0 OID 0)
-- Dependencies: 191
-- Name: auth_group_id_seq; Type: SEQUENCE OWNED BY; Schema: django_test; Owner: django_test
--

ALTER SEQUENCE django_test.auth_group_id_seq OWNED BY django_test.auth_group.id;


--
-- TOC entry 194 (class 1259 OID 25495)
-- Name: auth_group_permissions; Type: TABLE; Schema: django_test; Owner: django_test
--

CREATE TABLE django_test.auth_group_permissions (
    id integer NOT NULL,
    group_id integer NOT NULL,
    permission_id integer NOT NULL
);


ALTER TABLE django_test.auth_group_permissions OWNER TO django_test;

--
-- TOC entry 193 (class 1259 OID 25493)
-- Name: auth_group_permissions_id_seq; Type: SEQUENCE; Schema: django_test; Owner: django_test
--

CREATE SEQUENCE django_test.auth_group_permissions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE django_test.auth_group_permissions_id_seq OWNER TO django_test;

--
-- TOC entry 2295 (class 0 OID 0)
-- Dependencies: 193
-- Name: auth_group_permissions_id_seq; Type: SEQUENCE OWNED BY; Schema: django_test; Owner: django_test
--

ALTER SEQUENCE django_test.auth_group_permissions_id_seq OWNED BY django_test.auth_group_permissions.id;


--
-- TOC entry 190 (class 1259 OID 25477)
-- Name: auth_permission; Type: TABLE; Schema: django_test; Owner: django_test
--

CREATE TABLE django_test.auth_permission (
    id integer NOT NULL,
    name character varying(255) NOT NULL,
    content_type_id integer NOT NULL,
    codename character varying(100) NOT NULL
);


ALTER TABLE django_test.auth_permission OWNER TO django_test;

--
-- TOC entry 189 (class 1259 OID 25475)
-- Name: auth_permission_id_seq; Type: SEQUENCE; Schema: django_test; Owner: django_test
--

CREATE SEQUENCE django_test.auth_permission_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE django_test.auth_permission_id_seq OWNER TO django_test;

--
-- TOC entry 2296 (class 0 OID 0)
-- Dependencies: 189
-- Name: auth_permission_id_seq; Type: SEQUENCE OWNED BY; Schema: django_test; Owner: django_test
--

ALTER SEQUENCE django_test.auth_permission_id_seq OWNED BY django_test.auth_permission.id;


--
-- TOC entry 196 (class 1259 OID 25503)
-- Name: auth_user; Type: TABLE; Schema: django_test; Owner: django_test
--

CREATE TABLE django_test.auth_user (
    id integer NOT NULL,
    password character varying(128) NOT NULL,
    last_login timestamp with time zone,
    is_superuser boolean NOT NULL,
    username character varying(150) NOT NULL,
    first_name character varying(30) NOT NULL,
    last_name character varying(150) NOT NULL,
    email character varying(254) NOT NULL,
    is_staff boolean NOT NULL,
    is_active boolean NOT NULL,
    date_joined timestamp with time zone NOT NULL
);


ALTER TABLE django_test.auth_user OWNER TO django_test;

--
-- TOC entry 198 (class 1259 OID 25513)
-- Name: auth_user_groups; Type: TABLE; Schema: django_test; Owner: django_test
--

CREATE TABLE django_test.auth_user_groups (
    id integer NOT NULL,
    user_id integer NOT NULL,
    group_id integer NOT NULL
);


ALTER TABLE django_test.auth_user_groups OWNER TO django_test;

--
-- TOC entry 197 (class 1259 OID 25511)
-- Name: auth_user_groups_id_seq; Type: SEQUENCE; Schema: django_test; Owner: django_test
--

CREATE SEQUENCE django_test.auth_user_groups_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE django_test.auth_user_groups_id_seq OWNER TO django_test;

--
-- TOC entry 2297 (class 0 OID 0)
-- Dependencies: 197
-- Name: auth_user_groups_id_seq; Type: SEQUENCE OWNED BY; Schema: django_test; Owner: django_test
--

ALTER SEQUENCE django_test.auth_user_groups_id_seq OWNED BY django_test.auth_user_groups.id;


--
-- TOC entry 195 (class 1259 OID 25501)
-- Name: auth_user_id_seq; Type: SEQUENCE; Schema: django_test; Owner: django_test
--

CREATE SEQUENCE django_test.auth_user_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE django_test.auth_user_id_seq OWNER TO django_test;

--
-- TOC entry 2298 (class 0 OID 0)
-- Dependencies: 195
-- Name: auth_user_id_seq; Type: SEQUENCE OWNED BY; Schema: django_test; Owner: django_test
--

ALTER SEQUENCE django_test.auth_user_id_seq OWNED BY django_test.auth_user.id;


--
-- TOC entry 200 (class 1259 OID 25521)
-- Name: auth_user_user_permissions; Type: TABLE; Schema: django_test; Owner: django_test
--

CREATE TABLE django_test.auth_user_user_permissions (
    id integer NOT NULL,
    user_id integer NOT NULL,
    permission_id integer NOT NULL
);


ALTER TABLE django_test.auth_user_user_permissions OWNER TO django_test;

--
-- TOC entry 199 (class 1259 OID 25519)
-- Name: auth_user_user_permissions_id_seq; Type: SEQUENCE; Schema: django_test; Owner: django_test
--

CREATE SEQUENCE django_test.auth_user_user_permissions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE django_test.auth_user_user_permissions_id_seq OWNER TO django_test;

--
-- TOC entry 2299 (class 0 OID 0)
-- Dependencies: 199
-- Name: auth_user_user_permissions_id_seq; Type: SEQUENCE OWNED BY; Schema: django_test; Owner: django_test
--

ALTER SEQUENCE django_test.auth_user_user_permissions_id_seq OWNED BY django_test.auth_user_user_permissions.id;


--
-- TOC entry 202 (class 1259 OID 25581)
-- Name: django_admin_log; Type: TABLE; Schema: django_test; Owner: django_test
--

CREATE TABLE django_test.django_admin_log (
    id integer NOT NULL,
    action_time timestamp with time zone NOT NULL,
    object_id text,
    object_repr character varying(200) NOT NULL,
    action_flag smallint NOT NULL,
    change_message text NOT NULL,
    content_type_id integer,
    user_id integer NOT NULL,
    CONSTRAINT django_admin_log_action_flag_check CHECK ((action_flag >= 0))
);


ALTER TABLE django_test.django_admin_log OWNER TO django_test;

--
-- TOC entry 201 (class 1259 OID 25579)
-- Name: django_admin_log_id_seq; Type: SEQUENCE; Schema: django_test; Owner: django_test
--

CREATE SEQUENCE django_test.django_admin_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE django_test.django_admin_log_id_seq OWNER TO django_test;

--
-- TOC entry 2300 (class 0 OID 0)
-- Dependencies: 201
-- Name: django_admin_log_id_seq; Type: SEQUENCE OWNED BY; Schema: django_test; Owner: django_test
--

ALTER SEQUENCE django_test.django_admin_log_id_seq OWNED BY django_test.django_admin_log.id;


--
-- TOC entry 188 (class 1259 OID 25467)
-- Name: django_content_type; Type: TABLE; Schema: django_test; Owner: django_test
--

CREATE TABLE django_test.django_content_type (
    id integer NOT NULL,
    app_label character varying(100) NOT NULL,
    model character varying(100) NOT NULL
);


ALTER TABLE django_test.django_content_type OWNER TO django_test;

--
-- TOC entry 187 (class 1259 OID 25465)
-- Name: django_content_type_id_seq; Type: SEQUENCE; Schema: django_test; Owner: django_test
--

CREATE SEQUENCE django_test.django_content_type_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE django_test.django_content_type_id_seq OWNER TO django_test;

--
-- TOC entry 2301 (class 0 OID 0)
-- Dependencies: 187
-- Name: django_content_type_id_seq; Type: SEQUENCE OWNED BY; Schema: django_test; Owner: django_test
--

ALTER SEQUENCE django_test.django_content_type_id_seq OWNED BY django_test.django_content_type.id;


--
-- TOC entry 186 (class 1259 OID 25456)
-- Name: django_migrations; Type: TABLE; Schema: django_test; Owner: django_test
--

CREATE TABLE django_test.django_migrations (
    id integer NOT NULL,
    app character varying(255) NOT NULL,
    name character varying(255) NOT NULL,
    applied timestamp with time zone NOT NULL
);


ALTER TABLE django_test.django_migrations OWNER TO django_test;

--
-- TOC entry 185 (class 1259 OID 25454)
-- Name: django_migrations_id_seq; Type: SEQUENCE; Schema: django_test; Owner: django_test
--

CREATE SEQUENCE django_test.django_migrations_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE django_test.django_migrations_id_seq OWNER TO django_test;

--
-- TOC entry 2302 (class 0 OID 0)
-- Dependencies: 185
-- Name: django_migrations_id_seq; Type: SEQUENCE OWNED BY; Schema: django_test; Owner: django_test
--

ALTER SEQUENCE django_test.django_migrations_id_seq OWNED BY django_test.django_migrations.id;


--
-- TOC entry 207 (class 1259 OID 25631)
-- Name: django_session; Type: TABLE; Schema: django_test; Owner: django_test
--

CREATE TABLE django_test.django_session (
    session_key character varying(40) NOT NULL,
    session_data text NOT NULL,
    expire_date timestamp with time zone NOT NULL
);


ALTER TABLE django_test.django_session OWNER TO django_test;

--
-- TOC entry 204 (class 1259 OID 25611)
-- Name: polls_choice; Type: TABLE; Schema: django_test; Owner: django_test
--

CREATE TABLE django_test.polls_choice (
    id integer NOT NULL,
    choice_text character varying(200) NOT NULL,
    votes integer NOT NULL,
    test boolean NOT NULL,
    question_id integer NOT NULL
);


ALTER TABLE django_test.polls_choice OWNER TO django_test;

--
-- TOC entry 203 (class 1259 OID 25609)
-- Name: polls_choice_id_seq; Type: SEQUENCE; Schema: django_test; Owner: django_test
--

CREATE SEQUENCE django_test.polls_choice_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE django_test.polls_choice_id_seq OWNER TO django_test;

--
-- TOC entry 2303 (class 0 OID 0)
-- Dependencies: 203
-- Name: polls_choice_id_seq; Type: SEQUENCE OWNED BY; Schema: django_test; Owner: django_test
--

ALTER SEQUENCE django_test.polls_choice_id_seq OWNED BY django_test.polls_choice.id;


--
-- TOC entry 206 (class 1259 OID 25619)
-- Name: polls_question; Type: TABLE; Schema: django_test; Owner: django_test
--

CREATE TABLE django_test.polls_question (
    id integer NOT NULL,
    question_text character varying(200) NOT NULL,
    pub_date timestamp with time zone NOT NULL
);


ALTER TABLE django_test.polls_question OWNER TO django_test;

--
-- TOC entry 205 (class 1259 OID 25617)
-- Name: polls_question_id_seq; Type: SEQUENCE; Schema: django_test; Owner: django_test
--

CREATE SEQUENCE django_test.polls_question_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE django_test.polls_question_id_seq OWNER TO django_test;

--
-- TOC entry 2304 (class 0 OID 0)
-- Dependencies: 205
-- Name: polls_question_id_seq; Type: SEQUENCE OWNED BY; Schema: django_test; Owner: django_test
--

ALTER SEQUENCE django_test.polls_question_id_seq OWNED BY django_test.polls_question.id;


--
-- TOC entry 2076 (class 2604 OID 25488)
-- Name: auth_group id; Type: DEFAULT; Schema: django_test; Owner: django_test
--

ALTER TABLE ONLY django_test.auth_group ALTER COLUMN id SET DEFAULT nextval('django_test.auth_group_id_seq'::regclass);


--
-- TOC entry 2077 (class 2604 OID 25498)
-- Name: auth_group_permissions id; Type: DEFAULT; Schema: django_test; Owner: django_test
--

ALTER TABLE ONLY django_test.auth_group_permissions ALTER COLUMN id SET DEFAULT nextval('django_test.auth_group_permissions_id_seq'::regclass);


--
-- TOC entry 2075 (class 2604 OID 25480)
-- Name: auth_permission id; Type: DEFAULT; Schema: django_test; Owner: django_test
--

ALTER TABLE ONLY django_test.auth_permission ALTER COLUMN id SET DEFAULT nextval('django_test.auth_permission_id_seq'::regclass);


--
-- TOC entry 2078 (class 2604 OID 25506)
-- Name: auth_user id; Type: DEFAULT; Schema: django_test; Owner: django_test
--

ALTER TABLE ONLY django_test.auth_user ALTER COLUMN id SET DEFAULT nextval('django_test.auth_user_id_seq'::regclass);


--
-- TOC entry 2079 (class 2604 OID 25516)
-- Name: auth_user_groups id; Type: DEFAULT; Schema: django_test; Owner: django_test
--

ALTER TABLE ONLY django_test.auth_user_groups ALTER COLUMN id SET DEFAULT nextval('django_test.auth_user_groups_id_seq'::regclass);


--
-- TOC entry 2080 (class 2604 OID 25524)
-- Name: auth_user_user_permissions id; Type: DEFAULT; Schema: django_test; Owner: django_test
--

ALTER TABLE ONLY django_test.auth_user_user_permissions ALTER COLUMN id SET DEFAULT nextval('django_test.auth_user_user_permissions_id_seq'::regclass);


--
-- TOC entry 2081 (class 2604 OID 25584)
-- Name: django_admin_log id; Type: DEFAULT; Schema: django_test; Owner: django_test
--

ALTER TABLE ONLY django_test.django_admin_log ALTER COLUMN id SET DEFAULT nextval('django_test.django_admin_log_id_seq'::regclass);


--
-- TOC entry 2074 (class 2604 OID 25470)
-- Name: django_content_type id; Type: DEFAULT; Schema: django_test; Owner: django_test
--

ALTER TABLE ONLY django_test.django_content_type ALTER COLUMN id SET DEFAULT nextval('django_test.django_content_type_id_seq'::regclass);


--
-- TOC entry 2073 (class 2604 OID 25459)
-- Name: django_migrations id; Type: DEFAULT; Schema: django_test; Owner: django_test
--

ALTER TABLE ONLY django_test.django_migrations ALTER COLUMN id SET DEFAULT nextval('django_test.django_migrations_id_seq'::regclass);


--
-- TOC entry 2083 (class 2604 OID 25614)
-- Name: polls_choice id; Type: DEFAULT; Schema: django_test; Owner: django_test
--

ALTER TABLE ONLY django_test.polls_choice ALTER COLUMN id SET DEFAULT nextval('django_test.polls_choice_id_seq'::regclass);


--
-- TOC entry 2084 (class 2604 OID 25622)
-- Name: polls_question id; Type: DEFAULT; Schema: django_test; Owner: django_test
--

ALTER TABLE ONLY django_test.polls_question ALTER COLUMN id SET DEFAULT nextval('django_test.polls_question_id_seq'::regclass);


--
-- TOC entry 2271 (class 0 OID 25485)
-- Dependencies: 192
-- Data for Name: auth_group; Type: TABLE DATA; Schema: django_test; Owner: django_test
--

COPY django_test.auth_group (id, name) FROM stdin;
\.


--
-- TOC entry 2305 (class 0 OID 0)
-- Dependencies: 191
-- Name: auth_group_id_seq; Type: SEQUENCE SET; Schema: django_test; Owner: django_test
--

SELECT pg_catalog.setval('django_test.auth_group_id_seq', 1, false);


--
-- TOC entry 2273 (class 0 OID 25495)
-- Dependencies: 194
-- Data for Name: auth_group_permissions; Type: TABLE DATA; Schema: django_test; Owner: django_test
--

COPY django_test.auth_group_permissions (id, group_id, permission_id) FROM stdin;
\.


--
-- TOC entry 2306 (class 0 OID 0)
-- Dependencies: 193
-- Name: auth_group_permissions_id_seq; Type: SEQUENCE SET; Schema: django_test; Owner: django_test
--

SELECT pg_catalog.setval('django_test.auth_group_permissions_id_seq', 1, false);


--
-- TOC entry 2269 (class 0 OID 25477)
-- Dependencies: 190
-- Data for Name: auth_permission; Type: TABLE DATA; Schema: django_test; Owner: django_test
--

COPY django_test.auth_permission (id, name, content_type_id, codename) FROM stdin;
1	Can add choice	1	add_choice
2	Can change choice	1	change_choice
3	Can delete choice	1	delete_choice
4	Can view choice	1	view_choice
5	Can add question	2	add_question
6	Can change question	2	change_question
7	Can delete question	2	delete_question
8	Can view question	2	view_question
9	Can add log entry	3	add_logentry
10	Can change log entry	3	change_logentry
11	Can delete log entry	3	delete_logentry
12	Can view log entry	3	view_logentry
13	Can add user	4	add_user
14	Can change user	4	change_user
15	Can delete user	4	delete_user
16	Can view user	4	view_user
17	Can add group	5	add_group
18	Can change group	5	change_group
19	Can delete group	5	delete_group
20	Can view group	5	view_group
21	Can add permission	6	add_permission
22	Can change permission	6	change_permission
23	Can delete permission	6	delete_permission
24	Can view permission	6	view_permission
25	Can add content type	7	add_contenttype
26	Can change content type	7	change_contenttype
27	Can delete content type	7	delete_contenttype
28	Can view content type	7	view_contenttype
29	Can add session	8	add_session
30	Can change session	8	change_session
31	Can delete session	8	delete_session
32	Can view session	8	view_session
\.


--
-- TOC entry 2307 (class 0 OID 0)
-- Dependencies: 189
-- Name: auth_permission_id_seq; Type: SEQUENCE SET; Schema: django_test; Owner: django_test
--

SELECT pg_catalog.setval('django_test.auth_permission_id_seq', 32, true);


--
-- TOC entry 2275 (class 0 OID 25503)
-- Dependencies: 196
-- Data for Name: auth_user; Type: TABLE DATA; Schema: django_test; Owner: django_test
--

COPY django_test.auth_user (id, password, last_login, is_superuser, username, first_name, last_name, email, is_staff, is_active, date_joined) FROM stdin;
2	pbkdf2_sha256$120000$9pMtDgP7wjci$SbYFjETpPuGC4xtGJyCpGQUbCuIYeoU711gkvOX0aFk=	2018-12-12 16:45:27.348288+01	f	notadmin				t	t	2018-12-12 16:40:54+01
1	pbkdf2_sha256$120000$uNdDjMEmqNie$YhgZu8fmZRR4OD6CAE43Ux6B+OrH5yEzSWH5NYfsOSM=	2018-12-12 16:50:11.292664+01	t	admin			admin@djangoproject.com	t	t	2018-12-12 16:37:14.673194+01
\.


--
-- TOC entry 2277 (class 0 OID 25513)
-- Dependencies: 198
-- Data for Name: auth_user_groups; Type: TABLE DATA; Schema: django_test; Owner: django_test
--

COPY django_test.auth_user_groups (id, user_id, group_id) FROM stdin;
\.


--
-- TOC entry 2308 (class 0 OID 0)
-- Dependencies: 197
-- Name: auth_user_groups_id_seq; Type: SEQUENCE SET; Schema: django_test; Owner: django_test
--

SELECT pg_catalog.setval('django_test.auth_user_groups_id_seq', 1, false);


--
-- TOC entry 2309 (class 0 OID 0)
-- Dependencies: 195
-- Name: auth_user_id_seq; Type: SEQUENCE SET; Schema: django_test; Owner: django_test
--

SELECT pg_catalog.setval('django_test.auth_user_id_seq', 2, true);


--
-- TOC entry 2279 (class 0 OID 25521)
-- Dependencies: 200
-- Data for Name: auth_user_user_permissions; Type: TABLE DATA; Schema: django_test; Owner: django_test
--

COPY django_test.auth_user_user_permissions (id, user_id, permission_id) FROM stdin;
1	2	8
2	2	4
3	2	2
4	2	6
5	2	1
6	2	3
7	2	5
8	2	7
\.


--
-- TOC entry 2310 (class 0 OID 0)
-- Dependencies: 199
-- Name: auth_user_user_permissions_id_seq; Type: SEQUENCE SET; Schema: django_test; Owner: django_test
--

SELECT pg_catalog.setval('django_test.auth_user_user_permissions_id_seq', 8, true);


--
-- TOC entry 2281 (class 0 OID 25581)
-- Dependencies: 202
-- Data for Name: django_admin_log; Type: TABLE DATA; Schema: django_test; Owner: django_test
--

COPY django_test.django_admin_log (id, action_time, object_id, object_repr, action_flag, change_message, content_type_id, user_id) FROM stdin;
1	2018-12-12 16:40:27.120964+01	1	Who are you?	1	[{"added": {}}, {"added": {"object": "Me", "name": "choice"}}, {"added": {"object": "You", "name": "choice"}}, {"added": {"object": "Someone else", "name": "choice"}}]	2	1
2	2018-12-12 16:40:54.085729+01	2	notadmin	1	[{"added": {}}]	4	1
3	2018-12-12 16:41:08.78974+01	2	notadmin	2	[{"changed": {"fields": ["is_staff"]}}]	4	1
4	2018-12-12 16:41:53.778446+01	2	notadmin	2	[{"changed": {"fields": ["user_permissions"]}}]	4	1
5	2018-12-12 16:42:34.624952+01	2	notadmin	2	[{"changed": {"fields": ["user_permissions"]}}]	4	1
6	2018-12-12 16:45:20.556391+01	2	notadmin	2	[{"changed": {"fields": ["user_permissions"]}}]	4	1
7	2018-12-12 16:50:33.679459+01	2	How are you?	1	[{"added": {}}, {"added": {"name": "choice", "object": "Fine"}}, {"added": {"name": "choice", "object": "Damn fine"}}, {"added": {"name": "choice", "object": "Well, you know, fine"}}]	2	1
\.


--
-- TOC entry 2311 (class 0 OID 0)
-- Dependencies: 201
-- Name: django_admin_log_id_seq; Type: SEQUENCE SET; Schema: django_test; Owner: django_test
--

SELECT pg_catalog.setval('django_test.django_admin_log_id_seq', 7, true);


--
-- TOC entry 2267 (class 0 OID 25467)
-- Dependencies: 188
-- Data for Name: django_content_type; Type: TABLE DATA; Schema: django_test; Owner: django_test
--

COPY django_test.django_content_type (id, app_label, model) FROM stdin;
1	polls	choice
2	polls	question
3	admin	logentry
4	auth	user
5	auth	group
6	auth	permission
7	contenttypes	contenttype
8	sessions	session
\.


--
-- TOC entry 2312 (class 0 OID 0)
-- Dependencies: 187
-- Name: django_content_type_id_seq; Type: SEQUENCE SET; Schema: django_test; Owner: django_test
--

SELECT pg_catalog.setval('django_test.django_content_type_id_seq', 8, true);


--
-- TOC entry 2265 (class 0 OID 25456)
-- Dependencies: 186
-- Data for Name: django_migrations; Type: TABLE DATA; Schema: django_test; Owner: django_test
--

COPY django_test.django_migrations (id, app, name, applied) FROM stdin;
1	contenttypes	0001_initial	2018-12-12 16:34:26.374462+01
2	auth	0001_initial	2018-12-12 16:34:26.950575+01
3	admin	0001_initial	2018-12-12 16:34:27.108758+01
4	admin	0002_logentry_remove_auto_add	2018-12-12 16:34:27.127581+01
5	admin	0003_logentry_add_action_flag_choices	2018-12-12 16:34:27.158921+01
6	contenttypes	0002_remove_content_type_name	2018-12-12 16:34:27.183101+01
7	auth	0002_alter_permission_name_max_length	2018-12-12 16:34:27.199942+01
8	auth	0003_alter_user_email_max_length	2018-12-12 16:34:27.224856+01
9	auth	0004_alter_user_username_opts	2018-12-12 16:34:27.240763+01
10	auth	0005_alter_user_last_login_null	2018-12-12 16:34:27.267405+01
11	auth	0006_require_contenttypes_0002	2018-12-12 16:34:27.275625+01
12	auth	0007_alter_validators_add_error_messages	2018-12-12 16:34:27.299836+01
13	auth	0008_alter_user_username_max_length	2018-12-12 16:34:27.358851+01
14	auth	0009_alter_user_last_name_max_length	2018-12-12 16:34:27.383734+01
15	polls	0001_initial	2018-12-12 16:34:27.484172+01
16	sessions	0001_initial	2018-12-12 16:34:27.625731+01
\.


--
-- TOC entry 2313 (class 0 OID 0)
-- Dependencies: 185
-- Name: django_migrations_id_seq; Type: SEQUENCE SET; Schema: django_test; Owner: django_test
--

SELECT pg_catalog.setval('django_test.django_migrations_id_seq', 16, true);


--
-- TOC entry 2286 (class 0 OID 25631)
-- Dependencies: 207
-- Data for Name: django_session; Type: TABLE DATA; Schema: django_test; Owner: django_test
--

COPY django_test.django_session (session_key, session_data, expire_date) FROM stdin;
s2b3wxwdike0az2i4jxymr5dudwpcy6f	ZmQ2YjU4YzhkNTNhNWY5YjYyMjEzZjIzMjQyODZiZmY4NTIyN2U0Yjp7Il9hdXRoX3VzZXJfaGFzaCI6IjFhOWNhZTY4ZWEzZmE2YzYxNGIyNWRhMGQ1ZDMwODMyODlmMjYyZWEiLCJfYXV0aF91c2VyX2lkIjoiMiIsIl9hdXRoX3VzZXJfYmFja2VuZCI6ImRqYW5nby5jb250cmliLmF1dGguYmFja2VuZHMuTW9kZWxCYWNrZW5kIn0=	2018-12-26 16:45:27.356914+01
gguhc10regrooxpbbidr6k70apinz826	MDNmZTczOTljOGQyNGI5NjQ0NWFlNjJhNGM4OGM5ZDI4NGNmMjM4NDp7Il9hdXRoX3VzZXJfaGFzaCI6ImUyYmMxNGM2ODIyNDk0ZTFjNzlkZDFmZWQ2MjEwODBkNTUyYWMwNjciLCJfYXV0aF91c2VyX2lkIjoiMSIsIl9hdXRoX3VzZXJfYmFja2VuZCI6ImRqYW5nby5jb250cmliLmF1dGguYmFja2VuZHMuTW9kZWxCYWNrZW5kIn0=	2018-12-26 16:50:11.309726+01
\.


--
-- TOC entry 2283 (class 0 OID 25611)
-- Dependencies: 204
-- Data for Name: polls_choice; Type: TABLE DATA; Schema: django_test; Owner: django_test
--

COPY django_test.polls_choice (id, choice_text, votes, test, question_id) FROM stdin;
1	Me	0	t	1
2	You	0	t	1
3	Someone else	0	t	1
4	Fine	0	t	2
5	Damn fine	0	t	2
6	Well, you know, fine	0	t	2
\.


--
-- TOC entry 2314 (class 0 OID 0)
-- Dependencies: 203
-- Name: polls_choice_id_seq; Type: SEQUENCE SET; Schema: django_test; Owner: django_test
--

SELECT pg_catalog.setval('django_test.polls_choice_id_seq', 6, true);


--
-- TOC entry 2285 (class 0 OID 25619)
-- Dependencies: 206
-- Data for Name: polls_question; Type: TABLE DATA; Schema: django_test; Owner: django_test
--

COPY django_test.polls_question (id, question_text, pub_date) FROM stdin;
1	Who are you?	2018-12-12 16:40:21+01
2	How are you?	2018-12-12 16:50:17+01
\.


--
-- TOC entry 2315 (class 0 OID 0)
-- Dependencies: 205
-- Name: polls_question_id_seq; Type: SEQUENCE SET; Schema: django_test; Owner: django_test
--

SELECT pg_catalog.setval('django_test.polls_question_id_seq', 2, true);


--
-- TOC entry 2098 (class 2606 OID 25492)
-- Name: auth_group auth_group_name_key; Type: CONSTRAINT; Schema: django_test; Owner: django_test
--

ALTER TABLE ONLY django_test.auth_group
    ADD CONSTRAINT auth_group_name_key UNIQUE (name);


--
-- TOC entry 2103 (class 2606 OID 25547)
-- Name: auth_group_permissions auth_group_permissions_group_id_permission_id_0cd325b0_uniq; Type: CONSTRAINT; Schema: django_test; Owner: django_test
--

ALTER TABLE ONLY django_test.auth_group_permissions
    ADD CONSTRAINT auth_group_permissions_group_id_permission_id_0cd325b0_uniq UNIQUE (group_id, permission_id);


--
-- TOC entry 2106 (class 2606 OID 25500)
-- Name: auth_group_permissions auth_group_permissions_pkey; Type: CONSTRAINT; Schema: django_test; Owner: django_test
--

ALTER TABLE ONLY django_test.auth_group_permissions
    ADD CONSTRAINT auth_group_permissions_pkey PRIMARY KEY (id);


--
-- TOC entry 2100 (class 2606 OID 25490)
-- Name: auth_group auth_group_pkey; Type: CONSTRAINT; Schema: django_test; Owner: django_test
--

ALTER TABLE ONLY django_test.auth_group
    ADD CONSTRAINT auth_group_pkey PRIMARY KEY (id);


--
-- TOC entry 2093 (class 2606 OID 25533)
-- Name: auth_permission auth_permission_content_type_id_codename_01ab375a_uniq; Type: CONSTRAINT; Schema: django_test; Owner: django_test
--

ALTER TABLE ONLY django_test.auth_permission
    ADD CONSTRAINT auth_permission_content_type_id_codename_01ab375a_uniq UNIQUE (content_type_id, codename);


--
-- TOC entry 2095 (class 2606 OID 25482)
-- Name: auth_permission auth_permission_pkey; Type: CONSTRAINT; Schema: django_test; Owner: django_test
--

ALTER TABLE ONLY django_test.auth_permission
    ADD CONSTRAINT auth_permission_pkey PRIMARY KEY (id);


--
-- TOC entry 2114 (class 2606 OID 25518)
-- Name: auth_user_groups auth_user_groups_pkey; Type: CONSTRAINT; Schema: django_test; Owner: django_test
--

ALTER TABLE ONLY django_test.auth_user_groups
    ADD CONSTRAINT auth_user_groups_pkey PRIMARY KEY (id);


--
-- TOC entry 2117 (class 2606 OID 25562)
-- Name: auth_user_groups auth_user_groups_user_id_group_id_94350c0c_uniq; Type: CONSTRAINT; Schema: django_test; Owner: django_test
--

ALTER TABLE ONLY django_test.auth_user_groups
    ADD CONSTRAINT auth_user_groups_user_id_group_id_94350c0c_uniq UNIQUE (user_id, group_id);


--
-- TOC entry 2108 (class 2606 OID 25508)
-- Name: auth_user auth_user_pkey; Type: CONSTRAINT; Schema: django_test; Owner: django_test
--

ALTER TABLE ONLY django_test.auth_user
    ADD CONSTRAINT auth_user_pkey PRIMARY KEY (id);


--
-- TOC entry 2120 (class 2606 OID 25526)
-- Name: auth_user_user_permissions auth_user_user_permissions_pkey; Type: CONSTRAINT; Schema: django_test; Owner: django_test
--

ALTER TABLE ONLY django_test.auth_user_user_permissions
    ADD CONSTRAINT auth_user_user_permissions_pkey PRIMARY KEY (id);


--
-- TOC entry 2123 (class 2606 OID 25576)
-- Name: auth_user_user_permissions auth_user_user_permissions_user_id_permission_id_14a6b632_uniq; Type: CONSTRAINT; Schema: django_test; Owner: django_test
--

ALTER TABLE ONLY django_test.auth_user_user_permissions
    ADD CONSTRAINT auth_user_user_permissions_user_id_permission_id_14a6b632_uniq UNIQUE (user_id, permission_id);


--
-- TOC entry 2111 (class 2606 OID 25604)
-- Name: auth_user auth_user_username_key; Type: CONSTRAINT; Schema: django_test; Owner: django_test
--

ALTER TABLE ONLY django_test.auth_user
    ADD CONSTRAINT auth_user_username_key UNIQUE (username);


--
-- TOC entry 2126 (class 2606 OID 25590)
-- Name: django_admin_log django_admin_log_pkey; Type: CONSTRAINT; Schema: django_test; Owner: django_test
--

ALTER TABLE ONLY django_test.django_admin_log
    ADD CONSTRAINT django_admin_log_pkey PRIMARY KEY (id);


--
-- TOC entry 2088 (class 2606 OID 25474)
-- Name: django_content_type django_content_type_app_label_model_76bd3d3b_uniq; Type: CONSTRAINT; Schema: django_test; Owner: django_test
--

ALTER TABLE ONLY django_test.django_content_type
    ADD CONSTRAINT django_content_type_app_label_model_76bd3d3b_uniq UNIQUE (app_label, model);


--
-- TOC entry 2090 (class 2606 OID 25472)
-- Name: django_content_type django_content_type_pkey; Type: CONSTRAINT; Schema: django_test; Owner: django_test
--

ALTER TABLE ONLY django_test.django_content_type
    ADD CONSTRAINT django_content_type_pkey PRIMARY KEY (id);


--
-- TOC entry 2086 (class 2606 OID 25464)
-- Name: django_migrations django_migrations_pkey; Type: CONSTRAINT; Schema: django_test; Owner: django_test
--

ALTER TABLE ONLY django_test.django_migrations
    ADD CONSTRAINT django_migrations_pkey PRIMARY KEY (id);


--
-- TOC entry 2135 (class 2606 OID 25638)
-- Name: django_session django_session_pkey; Type: CONSTRAINT; Schema: django_test; Owner: django_test
--

ALTER TABLE ONLY django_test.django_session
    ADD CONSTRAINT django_session_pkey PRIMARY KEY (session_key);


--
-- TOC entry 2129 (class 2606 OID 25616)
-- Name: polls_choice polls_choice_pkey; Type: CONSTRAINT; Schema: django_test; Owner: django_test
--

ALTER TABLE ONLY django_test.polls_choice
    ADD CONSTRAINT polls_choice_pkey PRIMARY KEY (id);


--
-- TOC entry 2132 (class 2606 OID 25624)
-- Name: polls_question polls_question_pkey; Type: CONSTRAINT; Schema: django_test; Owner: django_test
--

ALTER TABLE ONLY django_test.polls_question
    ADD CONSTRAINT polls_question_pkey PRIMARY KEY (id);


--
-- TOC entry 2096 (class 1259 OID 25535)
-- Name: auth_group_name_a6ea08ec_like; Type: INDEX; Schema: django_test; Owner: django_test
--

CREATE INDEX auth_group_name_a6ea08ec_like ON django_test.auth_group USING btree (name varchar_pattern_ops);


--
-- TOC entry 2101 (class 1259 OID 25548)
-- Name: auth_group_permissions_group_id_b120cbf9; Type: INDEX; Schema: django_test; Owner: django_test
--

CREATE INDEX auth_group_permissions_group_id_b120cbf9 ON django_test.auth_group_permissions USING btree (group_id);


--
-- TOC entry 2104 (class 1259 OID 25549)
-- Name: auth_group_permissions_permission_id_84c5c92e; Type: INDEX; Schema: django_test; Owner: django_test
--

CREATE INDEX auth_group_permissions_permission_id_84c5c92e ON django_test.auth_group_permissions USING btree (permission_id);


--
-- TOC entry 2091 (class 1259 OID 25534)
-- Name: auth_permission_content_type_id_2f476e4b; Type: INDEX; Schema: django_test; Owner: django_test
--

CREATE INDEX auth_permission_content_type_id_2f476e4b ON django_test.auth_permission USING btree (content_type_id);


--
-- TOC entry 2112 (class 1259 OID 25564)
-- Name: auth_user_groups_group_id_97559544; Type: INDEX; Schema: django_test; Owner: django_test
--

CREATE INDEX auth_user_groups_group_id_97559544 ON django_test.auth_user_groups USING btree (group_id);


--
-- TOC entry 2115 (class 1259 OID 25563)
-- Name: auth_user_groups_user_id_6a12ed8b; Type: INDEX; Schema: django_test; Owner: django_test
--

CREATE INDEX auth_user_groups_user_id_6a12ed8b ON django_test.auth_user_groups USING btree (user_id);


--
-- TOC entry 2118 (class 1259 OID 25578)
-- Name: auth_user_user_permissions_permission_id_1fbb5f2c; Type: INDEX; Schema: django_test; Owner: django_test
--

CREATE INDEX auth_user_user_permissions_permission_id_1fbb5f2c ON django_test.auth_user_user_permissions USING btree (permission_id);


--
-- TOC entry 2121 (class 1259 OID 25577)
-- Name: auth_user_user_permissions_user_id_a95ead1b; Type: INDEX; Schema: django_test; Owner: django_test
--

CREATE INDEX auth_user_user_permissions_user_id_a95ead1b ON django_test.auth_user_user_permissions USING btree (user_id);


--
-- TOC entry 2109 (class 1259 OID 25605)
-- Name: auth_user_username_6821ab7c_like; Type: INDEX; Schema: django_test; Owner: django_test
--

CREATE INDEX auth_user_username_6821ab7c_like ON django_test.auth_user USING btree (username varchar_pattern_ops);


--
-- TOC entry 2124 (class 1259 OID 25601)
-- Name: django_admin_log_content_type_id_c4bce8eb; Type: INDEX; Schema: django_test; Owner: django_test
--

CREATE INDEX django_admin_log_content_type_id_c4bce8eb ON django_test.django_admin_log USING btree (content_type_id);


--
-- TOC entry 2127 (class 1259 OID 25602)
-- Name: django_admin_log_user_id_c564eba6; Type: INDEX; Schema: django_test; Owner: django_test
--

CREATE INDEX django_admin_log_user_id_c564eba6 ON django_test.django_admin_log USING btree (user_id);


--
-- TOC entry 2133 (class 1259 OID 25640)
-- Name: django_session_expire_date_a5c62663; Type: INDEX; Schema: django_test; Owner: django_test
--

CREATE INDEX django_session_expire_date_a5c62663 ON django_test.django_session USING btree (expire_date);


--
-- TOC entry 2136 (class 1259 OID 25639)
-- Name: django_session_session_key_c0390e0f_like; Type: INDEX; Schema: django_test; Owner: django_test
--

CREATE INDEX django_session_session_key_c0390e0f_like ON django_test.django_session USING btree (session_key varchar_pattern_ops);


--
-- TOC entry 2130 (class 1259 OID 25625)
-- Name: polls_choice_question_id_c5b4b260; Type: INDEX; Schema: django_test; Owner: django_test
--

CREATE INDEX polls_choice_question_id_c5b4b260 ON django_test.polls_choice USING btree (question_id);


--
-- TOC entry 2139 (class 2606 OID 25541)
-- Name: auth_group_permissions auth_group_permissio_permission_id_84c5c92e_fk_auth_perm; Type: FK CONSTRAINT; Schema: django_test; Owner: django_test
--

ALTER TABLE ONLY django_test.auth_group_permissions
    ADD CONSTRAINT auth_group_permissio_permission_id_84c5c92e_fk_auth_perm FOREIGN KEY (permission_id) REFERENCES django_test.auth_permission(id) DEFERRABLE INITIALLY DEFERRED;


--
-- TOC entry 2138 (class 2606 OID 25536)
-- Name: auth_group_permissions auth_group_permissions_group_id_b120cbf9_fk_auth_group_id; Type: FK CONSTRAINT; Schema: django_test; Owner: django_test
--

ALTER TABLE ONLY django_test.auth_group_permissions
    ADD CONSTRAINT auth_group_permissions_group_id_b120cbf9_fk_auth_group_id FOREIGN KEY (group_id) REFERENCES django_test.auth_group(id) DEFERRABLE INITIALLY DEFERRED;


--
-- TOC entry 2137 (class 2606 OID 25527)
-- Name: auth_permission auth_permission_content_type_id_2f476e4b_fk_django_co; Type: FK CONSTRAINT; Schema: django_test; Owner: django_test
--

ALTER TABLE ONLY django_test.auth_permission
    ADD CONSTRAINT auth_permission_content_type_id_2f476e4b_fk_django_co FOREIGN KEY (content_type_id) REFERENCES django_test.django_content_type(id) DEFERRABLE INITIALLY DEFERRED;


--
-- TOC entry 2141 (class 2606 OID 25556)
-- Name: auth_user_groups auth_user_groups_group_id_97559544_fk_auth_group_id; Type: FK CONSTRAINT; Schema: django_test; Owner: django_test
--

ALTER TABLE ONLY django_test.auth_user_groups
    ADD CONSTRAINT auth_user_groups_group_id_97559544_fk_auth_group_id FOREIGN KEY (group_id) REFERENCES django_test.auth_group(id) DEFERRABLE INITIALLY DEFERRED;


--
-- TOC entry 2140 (class 2606 OID 25551)
-- Name: auth_user_groups auth_user_groups_user_id_6a12ed8b_fk_auth_user_id; Type: FK CONSTRAINT; Schema: django_test; Owner: django_test
--

ALTER TABLE ONLY django_test.auth_user_groups
    ADD CONSTRAINT auth_user_groups_user_id_6a12ed8b_fk_auth_user_id FOREIGN KEY (user_id) REFERENCES django_test.auth_user(id) DEFERRABLE INITIALLY DEFERRED;


--
-- TOC entry 2143 (class 2606 OID 25570)
-- Name: auth_user_user_permissions auth_user_user_permi_permission_id_1fbb5f2c_fk_auth_perm; Type: FK CONSTRAINT; Schema: django_test; Owner: django_test
--

ALTER TABLE ONLY django_test.auth_user_user_permissions
    ADD CONSTRAINT auth_user_user_permi_permission_id_1fbb5f2c_fk_auth_perm FOREIGN KEY (permission_id) REFERENCES django_test.auth_permission(id) DEFERRABLE INITIALLY DEFERRED;


--
-- TOC entry 2142 (class 2606 OID 25565)
-- Name: auth_user_user_permissions auth_user_user_permissions_user_id_a95ead1b_fk_auth_user_id; Type: FK CONSTRAINT; Schema: django_test; Owner: django_test
--

ALTER TABLE ONLY django_test.auth_user_user_permissions
    ADD CONSTRAINT auth_user_user_permissions_user_id_a95ead1b_fk_auth_user_id FOREIGN KEY (user_id) REFERENCES django_test.auth_user(id) DEFERRABLE INITIALLY DEFERRED;


--
-- TOC entry 2144 (class 2606 OID 25591)
-- Name: django_admin_log django_admin_log_content_type_id_c4bce8eb_fk_django_co; Type: FK CONSTRAINT; Schema: django_test; Owner: django_test
--

ALTER TABLE ONLY django_test.django_admin_log
    ADD CONSTRAINT django_admin_log_content_type_id_c4bce8eb_fk_django_co FOREIGN KEY (content_type_id) REFERENCES django_test.django_content_type(id) DEFERRABLE INITIALLY DEFERRED;


--
-- TOC entry 2145 (class 2606 OID 25596)
-- Name: django_admin_log django_admin_log_user_id_c564eba6_fk_auth_user_id; Type: FK CONSTRAINT; Schema: django_test; Owner: django_test
--

ALTER TABLE ONLY django_test.django_admin_log
    ADD CONSTRAINT django_admin_log_user_id_c564eba6_fk_auth_user_id FOREIGN KEY (user_id) REFERENCES django_test.auth_user(id) DEFERRABLE INITIALLY DEFERRED;


--
-- TOC entry 2146 (class 2606 OID 25626)
-- Name: polls_choice polls_choice_question_id_c5b4b260_fk_polls_question_id; Type: FK CONSTRAINT; Schema: django_test; Owner: django_test
--

ALTER TABLE ONLY django_test.polls_choice
    ADD CONSTRAINT polls_choice_question_id_c5b4b260_fk_polls_question_id FOREIGN KEY (question_id) REFERENCES django_test.polls_question(id) DEFERRABLE INITIALLY DEFERRED;


-- Completed on 2018-12-13 08:22:50 CET

--
-- PostgreSQL database dump complete
--

