# -*- coding: utf-8 -*-
from __future__ import unicode_literals

import uuid
import django.db.models.deletion
from django.db import migrations, models


def fill_uuid(apps, schema_editor):
    db_alias = schema_editor.connection.alias
    Choice = apps.get_model('polls', 'Choice')
    for obj in Choice.objects.using(db_alias).all():
        obj.uuid = uuid.uuid4()
        obj.save()


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('polls', '0001_initial'),
    ]

    operations = [
        migrations.AddField(
            model_name='choice',
            name='uuid',
            field=models.UUIDField(null=True),
        ),
        migrations.RunPython(fill_uuid, migrations.RunPython.noop),
        migrations.AlterField(
            model_name='choice',
            name='uuid',
            field=models.UUIDField(primary_key=False, default=uuid.uuid4, serialize=False, editable=False),
        ),
        # rename the old id field before deleting it at the end of the
        # migration for compatibility with the sqlite.
        migrations.RenameField(
            model_name='choice',
            old_name='id',
            new_name='old_id'
        ),
        migrations.RenameField(
            model_name='choice',
            old_name='uuid',
            new_name='id'
        ),
        migrations.AlterField(
            model_name='choice',
            name='id',
            field=models.UUIDField(primary_key=True, default=uuid.uuid4, serialize=False, editable=False),
        ),
        migrations.RemoveField(model_name='choice', name='old_id'),
    ]
