# This test case reproduces Django bug #7411 but doesn't use Django. It
# exhibits a limitation in SQLite that was present in versions 3.6.4 and below

import sys
import sqlite3
conn = sqlite3.connect(":memory:")

print("test1.py")
print("Python Version: %s" % sys.version)
print("SQLite Version: %s" % conn.execute("select sqlite_version()").fetchone()[0])

# setup
c = conn.cursor()
c.execute("CREATE TABLE A (a)")
c.execute("INSERT INTO A VALUES (1)")
c.close()

# Start a SELECT statement
c1 = conn.cursor()
c1.execute("SELECT * FROM A")

# Make a change and then COMMIT it
c2 = conn.cursor()
c2.execute("INSERT INTO A VALUES (2)")
conn.commit()

print("Didn't crash")

conn.close()
