#!/usr/bin/python

# This test reproduces Python bug #10513

import os
import sqlite3
import sys

DBFILE = '/tmp/bug.sqlite3'

if __name__ == "__main__":
    if os.path.exists(DBFILE):
        os.unlink(DBFILE)
        pass
    conn = sqlite3.connect(DBFILE)

    print("test2.py")
    print("Python Version: %s" % sys.version)
    print("SQLite Version: %s" % conn.execute("select sqlite_version()").fetchone()[0])

    cursor = conn.cursor()
    cursor.execute('create table t(k primary key);')
    for i in range(3):
        cursor.execute('insert or replace into t(k) values(?);', (i,))
        pass
    c =  cursor.execute(' select k from t where k == ?;', (1,))
    conn.commit()
    r = c.fetchone()
    c =  cursor.execute(' select k from t where k == ?;', (2,))

    print("No error")
