# Generated by Django 2.0.6 on 2018-06-12 12:19
from django.db import migrations, models
import uuid


from common.migration_utils import CustomMigration


def step(x):
    def f(*args):
        print('\n\n\n\n\n\n')
        print('==================== STEP ========================= ', x, ' =====================')
        print('\n\n')
    return f


class Migration(CustomMigration):

    dependencies = [
        ('vario', '0026_populate_and_match_layout_uuids'),
    ]

    operations = [
        migrations.RunPython(code=step(1)),
        # we no longer need the link to layout id, remove it
        migrations.RemoveField(
            model_name='layoutfield',
            name='layout',
        ),

        migrations.RunPython(code=step(2)),
        # and rename the link to layout uuid to be called layout
        migrations.RenameField(
            model_name='layoutfield',
            old_name='temp_layout',
            new_name='layout'
        ),

        migrations.RunPython(code=step(3)),
        # remove the id PK in ExampleLayout
        migrations.RemoveField(
            model_name='examplelayout',
            name='id',
        ),

        migrations.RunPython(code=step(4)),
        # and make the uuid the new PK
        migrations.AlterField(
            model_name='examplelayout',
            name='uuid',
            field=models.UUIDField(default=uuid.uuid4, primary_key=True, editable=False),
        ),

        migrations.RunPython(code=step(5)),
        # remove the id PK in LayoutField
        migrations.RemoveField(
            model_name='layoutfield',
            name='id',
        ),

        migrations.RunPython(code=step(6)),
        # and make the uuid the new PK
        migrations.AlterField(
            model_name='layoutfield',
            name='uuid',
            field=models.UUIDField(default=uuid.uuid4, primary_key=True, editable=False),
        ),

        migrations.RunPython(code=step(7)),
        # and make the uuid link to ExampleLayout a proper FK
        migrations.AlterField(
            model_name='layoutfield',
            name='layout',
            field=models.ForeignKey(on_delete=models.deletion.CASCADE, related_name='fields', to='vario.ExampleLayout'),
        ),

        migrations.RunPython(code=step(8)),
    ]
