# Generated by Django 2.0.6 on 2018-06-12 12:19
from django.db import migrations, models
import uuid


from common.migration_utils import CustomMigration


def populate_and_match_uuids(apps, schema_editor):
    ExampleLayout = apps.get_model('vario', 'ExampleLayout')
    LayoutField = apps.get_model('vario', 'LayoutField')

    for layout in ExampleLayout.objects.all():
        layout.uuid = uuid.uuid4()
        layout.save()

    for field in LayoutField.objects.all():
        field.uuid = uuid.uuid4()
        field.temp_layout = field.layout.uuid
        field.save()


class Migration(CustomMigration):

    dependencies = [
        ('vario', '0025_custom_layouts_changes'),
    ]

    operations = [
        migrations.RunPython(
            code=populate_and_match_uuids,
            reverse_code=migrations.RunPython.noop
        ),
    ]
