from django.contrib import admin
from django import forms
from django.utils.html import format_html
#from dal import autocomplete
from django.forms import formset_factory
# Register your models here.
from .models import MetaDataNames, MetaDataValues, Document
from django.contrib.admin.widgets import FilteredSelectMultiple

from django.contrib.admin.utils import flatten_fieldsets
import logging

logger = logging.getLogger(__name__)



class DocumentForm(forms.ModelForm):
    
    def __init__(self, *args, **kwargs):
        logger.debug("DocumentForm __init__ START")
        super(DocumentForm, self).__init__(*args, **kwargs)
        metadata_names = MetaDataNames.objects.all()
        # create the fields
        for metadata in metadata_names:
            self.fields[metadata.name] = forms.ModelMultipleChoiceField(widget=FilteredSelectMultiple(metadata.name, is_stacked=False), required=False, queryset=MetaDataValues.objects.filter(meta_name_id=metadata.meta_name_id).order_by('value'),)
        logger.debug("self.fields=%s", self.fields)
        # initialize the fields here
        # Not important for this demo
        logger.debug("DocumentForm __init__ END")
    
    class Meta:
        model = Document
        fields = '__all__'
        
    # Need a clean method to package up the metadata into the JSONField
       

class DocumentAdmin(admin.ModelAdmin):
    form = DocumentForm
    list_display = ('doc_name', 'metadata', )
    
    fieldsets = (
        (None, {
            'fields': ('doc_name', ),
            'classes': ('extrapretty',),
        }),
    )
    
    def get_form(self, request, obj=None, **kwargs):
        kwargs['fields'] = flatten_fieldsets(self.fieldsets)
        return super(DocumentAdmin, self).get_form(request, obj, **kwargs)

    def get_fieldsets(self, request, obj=None):
        logger.debug("get_fieldsets START")
        fieldsets = super(DocumentAdmin, self).get_fieldsets(request, obj)
        newfieldsets = list(fieldsets)
        logger.debug("fieldsets=%s", newfieldsets)
        fields = []
        #metadata_names = MetaData.objects.filter(name__in = ['Title', 'Decade'])
        metadata_names = MetaDataNames.objects.all()
        for name in metadata_names:
            fields.append(name.name)
            #fields.append('metadata_select_%s' % i)
            #fields.append('metadata_value_%s' % i)
        #fields.sort(reverse=True)
        logger.debug("\tfields: %s", fields)
        newfieldsets.append(('Metadata Fields', {'fields': tuple(fields), 'classes': ('wide', 'required'),}))
        logger.debug("\tnewfieldsets:%s",newfieldsets)
        logger.debug("get_fieldsets END")
        return newfieldsets
        
    # Need a save method to save the cleaned data into the JSONField.
    
    


class MetaDataNamesAdmin(admin.ModelAdmin):
    feilds = ('name',)
    list_display = ('name', )
    
class MetaDataValuesAdmin(admin.ModelAdmin):
    list_display = ('value', 'get_metadata_name')
    
    def get_metadata_name(self, obj):
        return obj.meta_name_id
    get_metadata_name.admin_order_field  = 'meta_name_id'  #Allows column order sorting
    get_metadata_name.short_description = 'MetaData Name'  #Renames column head

admin.site.register(Document, DocumentAdmin)
admin.site.register(MetaDataNames, MetaDataNamesAdmin)
admin.site.register(MetaDataValues, MetaDataValuesAdmin)

