from django.conf import settings
from django.db import models
from django import forms
import jsonfield
import logging

logger = logging.getLogger(__name__)


class MetaDataNames(models.Model): 
    meta_name_id = models.AutoField(primary_key = True)
    name = models.CharField(max_length=200, unique=True)
    
    def __str__(self):
        return self.name

class MetaDataValues(models.Model): 
    meta_value_id = models.AutoField(primary_key = True)
    meta_name_id = models.ForeignKey(MetaDataNames, on_delete=models.CASCADE,)
    value = models.CharField(max_length=200, unique=True)
    
    def __str__(self):
        return self.value
    
class Document(models.Model):
    test_id = models.AutoField(primary_key = True)
    doc_name = models.CharField(max_length=200, unique=True)
    metadata = jsonfield.JSONField(blank=True)
