#!/usr/bin/env python3

import django
django.setup()

from django.db.models import OuterRef, Subquery
from myapp.models import ModelWithYear, ModelWithDate

dates = ModelWithDate.objects.filter(date__year__gte=OuterRef("year"))
dates_subq = Subquery(dates.values("id"))

years = ModelWithYear.objects.filter(date_ref__in=dates_subq)
print(years.query)
