from django.db import models


class ModelWithDate(models.Model):
    id = models.AutoField(primary_key=True)
    date = models.DateField()


class ModelWithYear(models.Model):
    id = models.AutoField(primary_key=True)
    year = models.IntegerField()
    date_ref = models.ForeignKey(to=ModelWithDate, on_delete=models.CASCADE)
