from django.db import models


class Orderable(models.Model):
    sort_order = models.IntegerField(null=True, blank=True)

    class Meta:
        abstract = True
        ordering = ['sort_order']


class Foo(models.Model):
    name = models.CharField(max_length=50)

    def __str__(self):
        return self.name

    class Meta:
        verbose_name = 'foo'
        verbose_name_plural = 'foos'


class Bar(Orderable, models.Model):
    foo = models.ForeignKey(Foo, blank=True, null=True, on_delete=models.CASCADE)
    name = models.CharField(max_length=50)

    def __str__(self):
        return '{}-{}'.format(self.name, self.sort_order)

    class Meta:
        verbose_name = 'bar'
        verbose_name_plural = 'bars'
        # ordering = ['sort_order']
