from urllib.parse import urljoin

from django.core.management import BaseCommand
from django.urls import reverse

from metainheritance.models import Foo, Bar


class Command(BaseCommand):

    def handle(self, *args, **options):
        Foo.objects.all().delete()
        Bar.objects.all().delete()  # for good measure

        foo = Foo.objects.create(name='Foo Manchu')

        Bar.objects.create(foo=foo, name='Bar 3', sort_order=3)
        Bar.objects.create(foo=foo, name='Bar 5', sort_order=5)
        Bar.objects.create(foo=foo, name='Bar 2', sort_order=2)
        Bar.objects.create(foo=foo, name='Bar 4', sort_order=4)
        Bar.objects.create(foo=foo, name='Bar 1', sort_order=1)

        print(urljoin('http://127.0.0.1:8000/', reverse('admin:metainheritance_foo_change', args=[foo.id])))
