from django.contrib import admin
from metainheritance.models import Foo, Bar


class BarInline(admin.StackedInline):
	model = Bar
	fields = ['foo', 'name', 'sort_order']
	extra = 0


class FooAdmin(admin.ModelAdmin):
	inlines = [BarInline]

admin.site.register(Foo, FooAdmin)
