from django.test import TestCase
from django.contrib.auth import get_user_model


class TestViews(TestCase):
    @classmethod
    def setUpTestData(cls):
        cls.user = get_user_model().objects.create(email='test@example.com')

    def test_404(self):
        resp = self.client.get('_non_existent_URL')
        self.assertEquals(resp.status_code, 404)

    def test_login(self):
        # fails with postgres
        self.client.force_login(self.user)
