# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import models
from django.contrib.contenttypes.models import ContentType
from django.contrib.contenttypes.fields import (
    GenericForeignKey,
    GenericRelation
)


class Status(models.Model):
    title = models.CharField(max_length=100)

    def __unicode__(self):
        return self.title


class Task(models.Model):
    title = models.CharField(max_length=100)
    status = models.ForeignKey(Status, on_delete=models.CASCADE)

    target_content_type = models.ForeignKey(ContentType,
                                            on_delete=models.CASCADE)
    target_id = models.PositiveIntegerField()
    target = GenericForeignKey('target_content_type', 'target_id')

    def __unicode__(self):
        return self.title


class Plan(models.Model):
    title = models.CharField(max_length=100)

    def __unicode__(self):
        return self.title


class Project(models.Model):
    title = models.CharField(max_length=100)
    plans = models.ManyToManyField(Plan)
    tasks = GenericRelation(
        Task,
        content_type_field='target_content_type',
        object_id_field='target_id',
    )

    def __unicode__(self):
        return self.title
