# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db.models import Prefetch
from django.shortcuts import render

from .models import Task, Project, Plan


def index(request):
    tasks = Task.objects.prefetch_related('status')
    projects = Project.objects \
        .prefetch_related(
            Prefetch('tasks', queryset=tasks),
            # Prefetch('tasks', to_attr='some_attr_name'),
        )
    plans = Plan.objects.prefetch_related(
        Prefetch('project_set', queryset=projects)
    )
    return render(request, './index.html', {
        'plans': plans
    })
