# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db.models import Prefetch
from django.test import TestCase

from .models import Task, Project, Plan


class PrefetchRelatedTestCaset(TestCase):
    def test_correct(self):
        tasks = Task.objects.prefetch_related('status')
        projects = Project.objects \
            .prefetch_related(
                Prefetch('tasks', queryset=tasks),
            )
        plans = Plan.objects.prefetch_related(
            Prefetch('project_set', queryset=projects)
        )

        with self.assertNumQueries(4):
            for plan in plans:
                for prj in plan.project_set.all():
                    for task in prj.tasks.all():
                        task.status

    def test_incorrect(self):
        tasks = Task.objects.prefetch_related('status')
        projects = Project.objects \
            .prefetch_related(
                Prefetch('tasks', queryset=tasks),
                Prefetch('tasks', to_attr='some_attr_name'),
            )
        plans = Plan.objects.prefetch_related(
            Prefetch('project_set', queryset=projects)
        )

        with self.assertNumQueries(5):
            for plan in plans:
                for prj in plan.project_set.all():
                    for task in prj.tasks.all():
                        task.status
