CREATE TABLE "django_migrations" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "app" varchar(255) NOT NULL, "name" varchar(255) NOT NULL, "applied" datetime NOT NULL);
CREATE TABLE sqlite_sequence(name,seq);
CREATE TABLE "django_content_type" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "app_label" varchar(100) NOT NULL, "model" varchar(100) NOT NULL);
CREATE UNIQUE INDEX django_content_type_app_label_model_76bd3d3b_uniq ON "django_content_type" ("app_label", "model");
CREATE TABLE "auth_group" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "name" varchar(80) NOT NULL UNIQUE);
;
CREATE TABLE "auth_group_permissions" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "group_id" integer NOT NULL REFERENCES "auth_group" ("id") DEFERRABLE INITIALLY DEFERRED, "permission_id" integer NOT NULL REFERENCES "auth_permission__old" ("id") DEFERRABLE INITIALLY DEFERRED);
CREATE UNIQUE INDEX auth_group_permissions_group_id_permission_id_0cd325b0_uniq ON "auth_group_permissions" ("group_id", "permission_id");
CREATE INDEX "auth_group_permissions_group_id_b120cbf9" ON "auth_group_permissions" ("group_id");
CREATE INDEX "auth_group_permissions_permission_id_84c5c92e" ON "auth_group_permissions" ("permission_id");
CREATE TABLE "auth_permission" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "content_type_id" integer NOT NULL REFERENCES "django_content_type" ("id") DEFERRABLE INITIALLY DEFERRED, "codename" varchar(100) NOT NULL, "name" varchar(255) NOT NULL);
CREATE UNIQUE INDEX auth_permission_content_type_id_codename_01ab375a_uniq ON "auth_permission" ("content_type_id", "codename");
CREATE INDEX "auth_permission_content_type_id_2f476e4b" ON "auth_permission" ("content_type_id");
CREATE TABLE "accounts_user" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "password" varchar(128) NOT NULL, "last_login" datetime NULL, "is_superuser" bool NOT NULL, "first_name" varchar(30) NOT NULL, "last_name" varchar(150) NOT NULL, "is_staff" bool NOT NULL, "is_active" bool NOT NULL, "date_joined" datetime NOT NULL, "email" varchar(254) NOT NULL UNIQUE, "username" varchar(150) NOT NULL UNIQUE);
;
;
CREATE TABLE "accounts_user_groups" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "user_id" integer NOT NULL REFERENCES "accounts_user" ("id") DEFERRABLE INITIALLY DEFERRED, "group_id" integer NOT NULL REFERENCES "auth_group" ("id") DEFERRABLE INITIALLY DEFERRED);
CREATE TABLE "accounts_user_user_permissions" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "user_id" integer NOT NULL REFERENCES "accounts_user" ("id") DEFERRABLE INITIALLY DEFERRED, "permission_id" integer NOT NULL REFERENCES "auth_permission" ("id") DEFERRABLE INITIALLY DEFERRED);
CREATE UNIQUE INDEX accounts_user_groups_user_id_group_id_59c0b32f_uniq ON "accounts_user_groups" ("user_id", "group_id");
CREATE INDEX "accounts_user_groups_user_id_52b62117" ON "accounts_user_groups" ("user_id");
CREATE INDEX "accounts_user_groups_group_id_bd11a704" ON "accounts_user_groups" ("group_id");
CREATE UNIQUE INDEX accounts_user_user_permissions_user_id_permission_id_2ab516c2_uniq ON "accounts_user_user_permissions" ("user_id", "permission_id");
CREATE INDEX "accounts_user_user_permissions_user_id_e4f0a161" ON "accounts_user_user_permissions" ("user_id");
CREATE INDEX "accounts_user_user_permissions_permission_id_113bb443" ON "accounts_user_user_permissions" ("permission_id");
CREATE TABLE "django_admin_log" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "object_id" text NULL, "object_repr" varchar(200) NOT NULL, "action_flag" smallint unsigned NOT NULL, "change_message" text NOT NULL, "content_type_id" integer NULL REFERENCES "django_content_type" ("id") DEFERRABLE INITIALLY DEFERRED, "user_id" integer NOT NULL REFERENCES "accounts_user" ("id") DEFERRABLE INITIALLY DEFERRED, "action_time" datetime NOT NULL);
CREATE INDEX "django_admin_log_content_type_id_c4bce8eb" ON "django_admin_log" ("content_type_id");
CREATE INDEX "django_admin_log_user_id_c564eba6" ON "django_admin_log" ("user_id");
CREATE TABLE "authtoken_token" ("key" varchar(40) NOT NULL PRIMARY KEY, "created" datetime NOT NULL, "user_id" integer NOT NULL UNIQUE REFERENCES "accounts_user" ("id") DEFERRABLE INITIALLY DEFERRED);
;
;
CREATE TABLE "constance_config" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "key" varchar(255) NOT NULL UNIQUE, "value" text NOT NULL);
;
CREATE TABLE "management_settings" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "email_enabled" bool NOT NULL, "email_from" varchar(128) NOT NULL, "email_smtp_server" varchar(128) NOT NULL, "email_smtp_port" integer NOT NULL, "email_smtp_login" varchar(128) NOT NULL, "email_smtp_password" varchar(128) NOT NULL, "registration_enabled" bool NOT NULL);
CREATE TABLE "x509_ca" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "name" varchar(64) NOT NULL, "notes" text NOT NULL, "key_length" varchar(6) NOT NULL, "digest" varchar(8) NOT NULL, "validity_start" datetime NULL, "validity_end" datetime NULL, "country_code" varchar(2) NOT NULL, "state" varchar(64) NOT NULL, "city" varchar(64) NOT NULL, "organization_name" varchar(64) NOT NULL, "organizational_unit_name" varchar(64) NOT NULL, "email" varchar(254) NOT NULL, "common_name" varchar(63) NOT NULL, "extensions" text NOT NULL, "serial_number" varchar(39) NULL, "certificate" text NOT NULL, "private_key" text NOT NULL, "created" datetime NOT NULL, "modified" datetime NOT NULL, "owner_id" integer NOT NULL REFERENCES "accounts_user" ("id") DEFERRABLE INITIALLY DEFERRED);
CREATE TABLE "x509_cert" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "name" varchar(64) NOT NULL, "notes" text NOT NULL, "key_length" varchar(6) NOT NULL, "digest" varchar(8) NOT NULL, "validity_start" datetime NULL, "validity_end" datetime NULL, "country_code" varchar(2) NOT NULL, "state" varchar(64) NOT NULL, "city" varchar(64) NOT NULL, "organization_name" varchar(64) NOT NULL, "organizational_unit_name" varchar(64) NOT NULL, "email" varchar(254) NOT NULL, "common_name" varchar(63) NOT NULL, "extensions" text NOT NULL, "serial_number" varchar(39) NULL, "certificate" text NOT NULL, "private_key" text NOT NULL, "created" datetime NOT NULL, "modified" datetime NOT NULL, "revoked" bool NOT NULL, "revoked_at" datetime NULL, "type" varchar(16) NOT NULL, "ca_id" integer NOT NULL REFERENCES "x509_ca" ("id") DEFERRABLE INITIALLY DEFERRED, "owner_id" integer NOT NULL REFERENCES "accounts_user" ("id") DEFERRABLE INITIALLY DEFERRED);
CREATE UNIQUE INDEX x509_cert_ca_id_serial_number_b5adb52a_uniq ON "x509_cert" ("ca_id", "serial_number");
CREATE INDEX "x509_ca_owner_id_1ad0a099" ON "x509_ca" ("owner_id");
CREATE INDEX "x509_cert_ca_id_0563d2a3" ON "x509_cert" ("ca_id");
CREATE INDEX "x509_cert_owner_id_2c02ee05" ON "x509_cert" ("owner_id");
CREATE TABLE "openvpn_dhparams" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "dhparams" text NOT NULL);
CREATE TABLE "openvpn_client" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "created" datetime NOT NULL, "name" varchar(64) NOT NULL, "cert_id" integer NOT NULL REFERENCES "x509_cert" ("id") DEFERRABLE INITIALLY DEFERRED, "owner_id" integer NOT NULL REFERENCES "accounts_user" ("id") DEFERRABLE INITIALLY DEFERRED, "server_id" integer NOT NULL REFERENCES "openvpn_server__old" ("id") DEFERRABLE INITIALLY DEFERRED);
CREATE INDEX "openvpn_client_cert_id_16e32e18" ON "openvpn_client" ("cert_id");
CREATE INDEX "openvpn_client_owner_id_887ae574" ON "openvpn_client" ("owner_id");
CREATE INDEX "openvpn_client_server_id_73c1a438" ON "openvpn_client" ("server_id");
CREATE TABLE "openvpn_server" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "created" datetime NOT NULL, "name" varchar(64) NOT NULL, "hostname" varchar(128) NOT NULL, "tls_auth_key" varchar(8192) NOT NULL, "protocol" varchar(10) NOT NULL, "ca_id" integer NOT NULL REFERENCES "x509_ca" ("id") DEFERRABLE INITIALLY DEFERRED, "cert_id" integer NOT NULL REFERENCES "x509_cert" ("id") DEFERRABLE INITIALLY DEFERRED, "dhparams_id" integer NOT NULL REFERENCES "openvpn_dhparams" ("id") DEFERRABLE INITIALLY DEFERRED, "owner_id" integer NOT NULL REFERENCES "accounts_user" ("id") DEFERRABLE INITIALLY DEFERRED, "dummy" varchar(64) NOT NULL);
CREATE INDEX "openvpn_server_ca_id_77c54543" ON "openvpn_server" ("ca_id");
CREATE INDEX "openvpn_server_cert_id_953a8378" ON "openvpn_server" ("cert_id");
CREATE INDEX "openvpn_server_dhparams_id_40e8505c" ON "openvpn_server" ("dhparams_id");
CREATE INDEX "openvpn_server_owner_id_ccca9dda" ON "openvpn_server" ("owner_id");
CREATE TABLE "django_session" ("session_key" varchar(40) NOT NULL PRIMARY KEY, "session_data" text NOT NULL, "expire_date" datetime NOT NULL);
;
CREATE INDEX "django_session_expire_date_a5c62663" ON "django_session" ("expire_date");
