from django import views
from django.template import loader
from django.http import HttpResponse

from . import forms
from . import models


# Create your views here.
class FormView(views.View):
    template = 'thing/form.html'

    def get(self, request):
        context = {'form': forms.SimpleForm()}
        template = loader.get_template(self.template)

        return HttpResponse(template.render(context, request))

    def post(self, request):
        base_model = models.BaseModel.objects.get(id=1)
        form = forms.SimpleForm(request.POST, initial={'hidden_fk': base_model})
        context = {'form': form}
        template = loader.get_template(self.template)

        simple_model = form.save(commit=False)
        simple_model.field = 1
        form.save()

        return HttpResponse(template.render(context, request))


class FormSetView(views.View):
    template = 'thing/formset.html'

    def get(self, request):
        context = {'formset': forms.SimpleFormset()}
        template = loader.get_template(self.template)

        return HttpResponse(template.render(context, request))

    def post(self, request):
        base_model = models.BaseModel.objects.get(id=1)

        formset = forms.SimpleFormset(
            request.POST,
            initial=[{'hidden_fk': base_model}] * forms.SimpleFormset.extra
        )

        context = {'formset': formset}
        template = loader.get_template(self.template)

        if formset.is_valid():
            formset.save()

        return HttpResponse(template.render(context, request))
