import commands
import os
from string import find
from optparse import OptionParser
import shutil
import sys
import urllib2

###################
#Install functions#
###################

#Install Python
def install_python():
    print "Checking your python version..."
    version = commands.getoutput('python --version')
    if version.find('Python 2.5') == 0:
    	print "Your python version is OK"
    else:
	print "Your python version is %s and required version is 2.5.X" % version
	print "Updating python..."
        try:
	    os.system("sudo apt-get install python2.5 > /dev/null")
        except:
	    sys.exit("Failed to install Python. Try to install it manually and rerun the script.")
	print "Python 2.5 was installed"

#Install Postgres
def install_postgres(options):
    if not options.local:
    	print "Checking your postgres version..."
    	if commands.getoutput('sudo apt-show-versions | grep postgresql-8.3'):
	    print "Your postgres version is OK"
    	else:
	    print "Your postgres version is not 8.3"
    	    print "Installing postgres... (This can take some time)"
	    try:
		print "Installing postgresql(1/4)..."
    	        os.system("sudo apt-get -y install postgresql-8.3 > /dev/null") 
		print "Installing postgresql-client(2/4)..."
		os.system("sudo apt-get -y install postgresql-client-8.3 > /dev/null")
		print "Installing postgresql-contrib(3/4)..."
		os.system("sudo apt-get -y install postgresql-contrib-8.3 > /dev/null")
		print "Installing pgadmin3(4/4)..."
		os.system("sudo apt-get -y install pgadmin3 > /dev/null")
	    except:
                print "Failed to install Postgres. Try to install it manually and rerun the script."
                exit()
	    print "Postgres was installed"
            print "Creating postgres user..."
	    try:
		os.system("echo \"ALTER USER postgres WITH PASSWORD 'qwerty123';\\q\" | sudo su postgres -c psql template1 > /dev/null")
                os.system("sudo passwd -d postgres > /dev/null")
                os.system("echo \"qwerty123\nqwerty123\" | sudo su postgres -c passwd 2>1& /dev/null")
    	    except:
		sys.exit("Failed to create postgres user. Try to create it manually and rerun the script.")
	    print "Postgres user created"

#Install Psycopg2
def install_psycopg2(options):
    if not options.local:
	print "Checking if you have psycopg2..."	
	if commands.getoutput("sudo apt-show-versions | grep psycopg2"):
	    print "Psycopg2 is installed"
	else:
	    print "Installing psycopg2..."
	    try:
		os.system("sudo apt-get -y install python2.5-psycopg2 > /dev/null")
	    except:
		sys.exit("Failed to install psycopg2. Try to install it manually and rerun the script.")
	    print "Psycopg2 was installed"

#Install Django
def install_django(dvd, output):
    print "Checking your django version..."
    if commands.getoutput('django-admin.py --version').startswith("1.0.2"):
        print "Your django version is OK"
    else:
	print "Installing django..."
    try:
        os.chdir("%s/linux" % dvd)
        shutil.copy("Django-1.0.2-final.tar.gz", "%s/Django-1.0.2-final.tar.gz" % output)
        os.chdir(output)
        if not os.path.exists("%s/Django-1.0.2-final" % output):
            os.system("sudo tar -zxvf Django-1.0.2-final.tar.gz > /dev/null")
        os.chdir("%s/Django-1.0.2-final" % output)
        os.system("sudo python2.5 setup.py install > /dev/null")
        os.unlink("%s/Django-1.0.2-final.tar.gz" % output)
    except:
        sys.exit("Failed to install django. Try to install it manually and rerun the script.")
	print "Django was installed"
	
#Install Apache2
def install_apache2():
    print "Checking if you have apache2..."
    if commands.getoutput("sudo apt-show-versions | grep apache2"):
	print "Apache2 is installed"
    else:
	print "Installing apache2..."
	try:
	    os.system("sudo apt-get -y install apache2 > /dev/null")
	except:
	    sys.exit("Failed to install apache2. Try to install it manually and rerun the script.")
	print "Apache2 was installed"

#Install mod_python
def install_mod_python():
    print "Checking if you have mod_python..."
    if commands.getoutput("sudo apt-show-versions | grep mod-python"):
        print "Mod_python is installed"
    else:
        print "Installing mod_python..."
        try:
            os.system("sudo apt-get -y install libapache2-mod-python > /dev/null")
        except:
            sys.exit("Failed to install mod_python. Try to install it manually and rerun the script.")
        print "Mod_python was installed"

#Install python_imaging
def install_python_imaging():
    print "Checking if you have python_imaging..."
    if commands.getoutput("sudo apt-show-versions | grep python-imaging"):
        print "Python_imaging is installed"
    else:
        print "Installing python_imaging..."
        try:
            os.system("sudo apt-get -y install python-imaging > /dev/null")
        except:
            sys.exit("Failed to install python_imaging. Try to install it manually and rerun the script.")
        print "Python_imaging was installed"

#Edit settings.py
def edit_settings(options, output):
    if not options.local:
        try:
	    file = open("%s/mx30/settings.py" % output, "r")
	    text = file.read()
	    file.close()
	    text = text.replace("DATABASE_ENGINE = 'sqlite3'", "DATABASE_ENGINE = 'postgresql_psycopg2'")
	    text = text.replace("peer_center.db", "peer_center")
	    text = text.replace("DATABASE_USER = ''", "DATABASE_USER = 'postgres'")
	    text = text.replace("DATABASE_PASSWORD = ''", "DATABASE_PASSWORD = 'qwerty123'")
	    text = text.replace("DATABASE_HOST = ''", "DATABASE_HOST = 'localhost'")
	    file = open("settings.py", "w")
            file.write(text)
            file.close()
	except:
	    sys.exit("Failed to edit settings")
    print "setting.py is OK"
	
#Copying mx30 directory, media, admin media and configure settings
def copy_and_configure(options, dvd, output):
    print "Copying mx30 directory..."
    os.chdir(dvd)
    try:
        if not os.path.exists("%s/mx30" % output):
            shutil.copytree("mx30", "%s/mx30" % output)
            os.chdir("%s/mx30" % output)
            os.system("sudo chmod -R 777 *")
            print "mx30 directory was copied"
        else:
	        print "You have mx30 directory in %s already" % output
    except:
        sys.exit("Failed to copy mx30 directory")
    edit_settings(options, output)
    try:
        if not os.path.exists("/var/www/media"):
    	    shutil.move("%s/mx30/media" % output, "/var/www/media")
            os.rename("/var/www/media", "/var/www/site_media")
        else:
            print "You have media directory already" 
    except:
	sys.exit("Failed to move media directory")
    try:
        if not os.path.exists("/var/www/media"):
            shutil.copytree("%s/Django-1.0.2-final/django/contrib/admin/media" % output, "/var/www/media")
        else:
            print "You have admin media directory already"
    except:
        sys.exit("Failed to copy admin media directory")
    print "Media directories are OK"

#Create database and load the data
def create_db(output):
    try:
    	os.system("echo \"qwerty123\n\" | sudo python %s/mx30/scripts/peer_center_install.pyc %s/mx30 > /dev/null" % (output, output)) 
    except:	
        sys.exit("Failed to create the database and load the data.")
    print "DB was created and data was loaded"

#Configure ip and prefix
def configure_ip_and_prefix(options, output):
    try:
        if options.ip:
	    os.system("sudo python %s/mx30/scripts/mx_config.pyc -i %s --prefix=/peergw" % (output, options.ip.split(":")[0]))
        else:
	    os.system("sudo python %s/mx30/scripts/mx_config.pyc -i localhost --prefix=/peergw" % output)
    except:
	sys.exit("Failed to configure ip and prefix")
    print "IP and prefix were configured"

#Configure and restart apache
def configure_and_restart_apache(output):
    django_in_apache = commands.getoutput('sudo cat /etc/apache2/httpd.conf | grep "DJANGO_SETTINGS_MODULE"')
    if django_in_apache:
        print "Your apache is configured already"
    else:
        try:
	    shutil.copy("/etc/apache2/httpd.conf", "/etc/apache2/httpd_orig.conf")    
            file = open("%s/mx30/scripts/apache_conf.txt" % output, 'r')
            text = file.read()
	    file.close()
            file = open("/etc/apache2/httpd.conf", 'w')
	    file.write(text.replace("c:/mxhw", output))
	    file.close()
	    os.system('sudo echo "Listen 7777" >> /etc/apache2/httpd.conf')
	except:
	    sys.exit("Failed to configue apache")      
	try:
	    os.system('sudo /etc/init.d/apache2 restart')
	except:
	    sys.exit("Failed to restart apache")
 	print "Apache was configured and restarted"	   

###############
#Main function#
###############
  
def main():
    
    ########################
    #Parsing script options#
    ########################

    parser = OptionParser()
    usage = "usage: mx_config [options] -i <install dvd location> -o <desired install location>"
    parser.add_option("-i", "--input", dest="input", help="mx30 directory location for the installation")
    parser.add_option("-o", "--output", dest="output", help="desired install directory location")
    parser.add_option("-l", action="store_true", dest="local", help="Local installation")
    parser.add_option("-I", "--ip", dest="ip", help="your ip")
    (options, args) = parser.parse_args()

    if not os.getuid()==0:
        sys.exit("You must be root to run this script")
    req = urllib2.Request('http://www.google.com')
    try:
        urllib2.urlopen(req)
    except:
        sys.exit("You must be connected to the internet to run this script")
    if not options.input:
        sys.exit("You should provide install dvd location. Use '-i' option.")
    if not options.output:
        sys.exit("You should provide the desired install location. Use '-o' option.")

    dvd = os.path.abspath(options.input.split("mx30")[0])
    output = os.path.abspath(options.output.split("mx30")[0]) 

    ###################
    #Install procedure#
    ###################

    print "Updating apt-get... (This can take some time)"
    os.system("sudo apt-get update > /dev/null")
    os.system("sudo apt-get -y install apt-show-versions > /dev/null")
    print "Finished updating apt-get"
    print "Copying files..."
    shutil.copytree(dvd, "%s/dvd" % output)
    dvd = os.path.abspath("%s/dvd" % output)
    os.system("sudo chmod 777 -R %s" % dvd)
    print "Finished copying files"
    os.chdir(dvd)
    install_python() 
    install_postgres(options)
    install_psycopg2(options)
    install_django(dvd, output)
    install_apache2()
    install_mod_python()	
    install_python_imaging()
    copy_and_configure(options, dvd, output)
    create_db(output)
    configure_ip_and_prefix(options, output)
    configure_and_restart_apache(output)
    print "Deleting temporary files..."
    shutil.rmtree(dvd)

    if options.ip:
        print "The installation was finished successfully. You application is running on: %s/peergw" % options.ip.split(":")[0]
    else:
        print "The installation was finished successfully. You application is running on: localhost/peergw"
	
if __name__ == "__main__":
    main()
