# -*- coding: utf-8 -*-

# Django
from django.conf import settings
from django.contrib.auth import get_user_model
from django.db import models

# django-model-utils
from model_utils.managers import InheritanceManager


class BaseLicense(models.Model):
    #objects = InheritanceManager()

    user = models.ForeignKey(settings.AUTH_USER_MODEL, on_delete=models.PROTECT)

    def __str__(self):
        return 'BaseLicense<{0}>'.format(self.id)


class LicenseManager(models.Manager):
    def get_by_natural_key(self, user_nk, license_key):
        user = get_user_model().objects.get_by_natural_key(*user_nk)
        return self.get(user=user, license_key=license_key)


class AdobePhotoshopLicense(BaseLicense):
    license_key = models.TextField()

    objects = LicenseManager()

    def natural_key(self):
        return (self.user.natural_key(), self.license_key)

    natural_key.dependencies = [settings.AUTH_USER_MODEL]

    def __str__(self):
        return 'AdobePhotoshopLicense<{0}, {1}>'.format(
            self.user.email,
            self.license_key,
        )


class CorelDrawLicense(BaseLicense):
    license_key = models.TextField()

    objects = LicenseManager()

    def natural_key(self):
        return (self.user.natural_key(), self.license_key)

    natural_key.dependencies = [settings.AUTH_USER_MODEL]

    def __str__(self):
        return 'CorelDrawLicense<{0}, {1}>'.format(
            self.user.email,
            self.license_key,
        )
