from django.db import models

class Subject(models.Model):
	name = models.CharField(maxlength=40)

class Course(models.Model):
	name = models.CharField(maxlength=40)
	subject = models.ForeignKey(Subject)
	class Meta:
		ordering = ["subject"]

class Class(models.Model):
	course = models.ForeignKey(Course)
	name = models.CharField(maxlength = 40)
    
	class Meta:
		ordering = ["course"]


__test__ = {'API_TESTS':"""
>>> s = Subject(name='Web Apps')
>>> s.save()
>>> c = Course(name='Djangology', subject=s)
>>> c.save()
>>> cl = Class(course=c, name='Django 101')
>>> cl.save()
>>> Class.objects.all().order_by('course')
[<Class: Class object>]
"""}