from django.test import TestCase, override_settings
from django.conf import settings

TEST_SETTINGS = {
    'MY_DATA': {
        'foo': 1,
        'bar': 2
    }
}


class Dummy:
    def foo(self):
        return settings.MY_DATA.get('foo')

    def bar(self):
        return settings.MY_DATA.get('bar')


@override_settings(**TEST_SETTINGS)
class SimpleTest(TestCase):
    def setUp(self):
        self.dummy = Dummy()

    def test_foobar(self):
        self.assertEqual(self.dummy.foo(), 1)
        self.assertEqual(self.dummy.bar(), 2)

    @override_settings()
    def test_delete_my_data(self):
        del settings.MY_DATA
        with self.assertRaises(AttributeError):
            self.dummy.foo()
        with self.assertRaises(AttributeError):
            self.dummy.bar()

    @override_settings()
    def test_delete_foo(self):
        del settings.MY_DATA['foo']
        self.assertIsNone(self.dummy.foo())
        self.assertEqual(self.dummy.bar(), 2)

    def test_foobar_again(self):
        self.assertEqual(self.dummy.foo(), 1)
        self.assertEqual(self.dummy.bar(), 2)
