
# Django first-party

from django.db import models
from django.utils.translation import (
	ugettext_lazy as _
)


class ItemType(models.Model):
	name = models.CharField(_('Name'), unique=True, max_length=255)

	class Meta:
		managed = True
		db_table = 'item_type'
		ordering = ['name']

		indexes = [
			models.Index(fields=['id'], name='item_type_index_1'),
			models.Index(fields=['-id'], name='item_type_index_2'),
			models.Index(fields=['names'], name='item_type_index_3'),
			models.Index(fields=['-names'], name='item_type_index_4')
		]
		
