from threading import current_thread


class CUserMiddleware(object):
    """Get current operating request and user"""
    _user = {}

    def process_request(self, request):
        self._user[current_thread()] = request.user

    def process_response(self, request, response):
        # TODO cleanup by alive session, if user session expired, remove all
        # items related to the user (dict value).
        # self._user.pop(current_thread(), None)  # clean to avoid it grows
        if len(self._user) > 1000:
            self._user = {}
        return response

    @classmethod
    def get_user(cls, default=None):
        # debug('当前用户: {}'.format(cls._user.get(current_thread(), default)))
        return cls._user.get(current_thread(), default)


def current_user():
    return CUserMiddleware.get_user()
