from django.db import models
from django.db.models import Q

from proj.middleware import current_user


def limit_export_branch():
    u = current_user()
    if u:
        print('\tlimit_export_branch worked the right way')
        return Q(name__endswith='something')
    print('\tlimit_export_branch works in wrong way')
    # import traceback
    # traceback.print_stack()
    return Q(pk=-1)  # deny to avoid info leak


class Branch(models.Model):
    name = models.CharField(max_length=16)

    def __str__(self):
        return self.name


class Export(models.Model):
    name = models.CharField(max_length=16)
    branch = models.ForeignKey(Branch, limit_choices_to=limit_export_branch)

    def __str__(self):
        return self.name
