from django.test import TestCase
from issue28107 import models


# Create your tests here.

class Test28107(TestCase):
    def setUp(self):
        vma1 = models.Vma.objects.create(objectid=1, powergrid_id=1, name="VMA 1")
        vma2 = models.Vma.objects.create(objectid=2, powergrid_id=2, name="VMA 2")
        tr1 = models.Treatment.objects.create(objectid=1, globalid="{treatment-1}", site_num="Site 1")
        tr2 = models.Treatment.objects.create(objectid=2, globalid="{treatment-2}", site_num="Site 2")
        models.Intersect.objects.create(vma=vma1, treatment_area=tr1, is_selected=False)
        models.Intersect.objects.create(vma=vma2, treatment_area=tr1, is_selected=True)
        models.Intersect.objects.create(vma=vma1, treatment_area=tr2, is_selected=True)
        models.Intersect.objects.create(vma=vma2, treatment_area=tr2, is_selected=False)

    def test_it(self):
        trs = models.Treatment.objects.all().annotate_vma()
        for tr in trs:
            print(tr.site_num, " vmas: ", tr.vma_count)
            self.assertTrue(tr.vma_count == 2)

