# -*- coding: utf-8 -*-
# Generated by Django 1.11 on 2017-04-29 03:19
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Intersect',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('is_selected', models.BooleanField(default='True', verbose_name='selected')),
            ],
        ),
        migrations.CreateModel(
            name='Treatment',
            fields=[
                ('objectid', models.IntegerField(editable=False, primary_key=True, serialize=False)),
                ('globalid', models.CharField(editable=False, max_length=38, unique=True)),
                ('site_num', models.CharField(blank=True, max_length=20, null=True)),
            ],
            options={
                'ordering': ('site_num',),
            },
        ),
        migrations.CreateModel(
            name='Vma',
            fields=[
                ('objectid', models.IntegerField(editable=False, primary_key=True, serialize=False)),
                ('powergrid_id', models.IntegerField(editable=False, unique=True)),
                ('name', models.CharField(blank=True, max_length=51, null=True)),
            ],
        ),
        migrations.AddField(
            model_name='treatment',
            name='vma_set',
            field=models.ManyToManyField(blank=True, through='issue28107.Intersect', to='issue28107.Vma'),
        ),
        migrations.AddField(
            model_name='intersect',
            name='treatment_area',
            field=models.ForeignKey(db_column='prescription_globalid', db_constraint=False, on_delete=django.db.models.deletion.CASCADE, to='issue28107.Treatment', to_field='globalid'),
        ),
        migrations.AddField(
            model_name='intersect',
            name='vma',
            field=models.ForeignKey(db_column='vma_powergrid_id', db_constraint=False, on_delete=django.db.models.deletion.CASCADE, to='issue28107.Vma', to_field='powergrid_id'),
        ),
        migrations.AlterUniqueTogether(
            name='intersect',
            unique_together=set([('vma', 'treatment_area')]),
        ),
    ]
