from django.db import models
from django.db.models import query, Count


class VMAintersectQuerySet(query.QuerySet):

    def annotate_vma(self):
        return self.annotate(vma_count=Count('vma_set'))


class Vma(models.Model):
    objectid = models.IntegerField(primary_key=True, editable=False)
    powergrid_id = models.IntegerField(unique=True, editable=False)
    name = models.CharField(max_length=51, blank=True, null=True)

class Intersect(models.Model):
    """
    M2M defines spatial intersection between Treatment and VMA
    """
    # "fake" foreign keys!
    vma = models.ForeignKey(Vma, db_column='vma_powergrid_id',
                                       to_field='powergrid_id', db_constraint=False)

    treatment_area = models.ForeignKey("Treatment", db_column='prescription_globalid',
                                      to_field='globalid', db_constraint=False)

    # Is this the selected intersection?
    is_selected = models.BooleanField('selected', default='True')

    class Meta:
        unique_together = (('vma', 'treatment_area'),)

class Treatment(models.Model):
    objectid = models.IntegerField(primary_key=True, editable=False)
    globalid = models.CharField(max_length=38, unique=True, editable=False)
    site_num = models.CharField(max_length=20, blank=True, null=True)
    vma_set = models.ManyToManyField(Vma, through=Intersect, blank=True)

    class Meta:
        ordering = ('site_num', )
        #managed = False
        #db_table = 'issue28107_treatment_vw'

    objects = VMAintersectQuerySet.as_manager()
