
replaces_statements = {}

for app in APPS:
    app_migrations_path = os.path.join(DJANGO_PATH, app, "migrations")
    if not os.path.exists(app_migrations_path):
        # No migration for this app
        continue

    # Listing migration files, and removing them
    migration_files = []
    for f in os.listdir(app_migrations_path):
        filepath = os.path.join(app_migrations_path, f)
        if f.endswith('.py') and '__init__' not in f:
            migration_files.append(f)
            os.unlink(filepath)

    if len(migration_files) == 0:
        continue

    # Generating "replaces" statement
    replace_statement = "    replaces = ["
    for i, f in enumerate(sorted(migration_files)):

        migration_name = f[:-3] # Removing .py from name

        replace_statement += "('%s', '%s'), " % (app, migration_name)

    replaces_statements[app] = replace_statement + "]"

# Calling makemigrations
os.chdir(DJANGO_PATH)
call(["python", "manage.py", "makemigrations"])


reset_migration_names =  "0001_initial_reset_%s" % timezone.now().strftime("%Y%m%d%H%M%S")

for app in APPS:
    app_migrations_path = os.path.join(DJANGO_PATH, app, "migrations")
    if not os.path.exists(app_migrations_path):
        # No migration for this app
        continue

    # Looking for freshly generated 0001_initial.py file
    for f in os.listdir(app_migrations_path):
        filepath = os.path.join(app_migrations_path, f)
        if f == "0001_initial.py":

            # Reading file
            with open(filepath) as migration_file:
                content = migration_file.read()

            # Removing file
            os.unlink(filepath)

            # Writing a new initial migrations (initial_reset)
            content = content.split('\n')
            new_content = []
            for i, line in enumerate(content):
                # Rename '0001_initial' to new migration name
                line = line.replace("0001_initial", reset_migration_names)
                new_content.append(line)
                # Add 'replaces' statement
                if line.startswith("class Migration"):
                    new_content.append(replaces_codes[app])

            with open(os.path.join(app_migrations_path, reset_migration_names + ".py"), "w") as migration_file:
                migration_file.write('\n'.join(new_content))