# -*- coding: utf-8 -*-
# Generated by Django 1.10.4 on 2017-01-16 16:03


from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    replaces = [('jobs', '0001_squashed_0005_auto_20160112_1717'), ('jobs', '0002_service_server_type'), ('jobs', '0003_auto_20160503_1410'), ('jobs', '0004_auto_20160505_1459'), ('jobs', '0005_auto_20160512_1638'), ('jobs', '0006_auto_20160516_1516'), ('jobs', '0007_auto_20160527_1052'), ('jobs', '0008_auto_20160527_1320'), ('jobs', '0009_auto_20160701_1129'), ('jobs', '0010_auto_20160818_1120'), ('jobs', '0011_auto_20160914_1256'), ('jobs', '0012_auto_20161201_1401'), ('jobs', '0013_auto_20170113_1455'), ('jobs', '0014_auto_20170113_1509'), ('jobs', '0015_auto_20170113_1515'), ('jobs', '0016_auto_20170116_1101')]

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('stores', '0001_squashed_0010_auto_20160929_1341'),
    ]

    operations = [
        migrations.CreateModel(
            name='job',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('state', models.CharField(choices=[('P', 'Pending'), ('A', 'Active'), ('C', 'Completed'), ('F', 'Failed')], default='P', max_length=1)),
                ('start_date', models.DateTimeField()),
                ('end_date', models.DateTimeField()),
            ],
        ),
        migrations.CreateModel(
            name='JobGroup',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('job_type', models.CharField(max_length=100)),
                ('created_by', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ('created_date', models.DateTimeField(auto_now_add=True)),
                ('queued_date', models.DateTimeField(null=True)),
            ],
        ),
        migrations.CreateModel(
            name='JobLog',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('command', models.TextField()),
                ('command_output', models.TextField()),
                ('result', models.BooleanField(default=False)),
                ('job', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='logs', to='jobs.Job')),
            ],
        ),
        migrations.AddField(
            model_name='job',
            name='job_group',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='jobs.JobGroup'),
        ),
        migrations.AddField(
            model_name='job',
            name='store',
            field=models.CharField(max_length=40),
        ),
        migrations.CreateModel(
            name='Service',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('service_name', models.CharField(max_length=40)),
                ('human_readable_name', models.CharField(max_length=40)),
                ('server_type', models.CharField(choices=[('rxs', 'Rx Server'), ('app', 'VMHost 1'), ('app01', 'App01'), ('web01', 'Web01'), ('gw01', 'GW01'), ('db01', 'DB01')], max_length=5)),
            ],
            options={
                'ordering': ['human_readable_name'],
            },
        ),
        migrations.AlterField(
            model_name='job',
            name='end_date',
            field=models.DateTimeField(null=True),
        ),
        migrations.AlterModelOptions(
            name='job',
            options={'permissions': (('deployment_jo', 'Access the Deployment jo'), ('services_jo', 'Access the System Services jo'), ('offline_status_jo', 'Access the Offline Status jo'), ('store_messages_jo', 'Access the Store Messages jo'))},
        ),
        migrations.AddField(
            model_name='job',
            name='payload',
            field=models.TextField(default=''),
            preserve_default=False,
        ),
        migrations.AlterField(
            model_name='job',
            name='start_date',
            field=models.DateTimeField(null=True),
        ),
        migrations.AlterModelOptions(
            name='job',
            options={'permissions': (('deployment_jo', 'Access Deployment jo'), ('services_jo', 'Access System Services jo'), ('offline_status_jo', 'Access Offline Status jo'))},
        ),
        migrations.AlterField(
            model_name='job',
            name='job_group',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='jobs', to='jobs.JobGroup'),
        ),
        migrations.CreateModel(
            name='JobParameter',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100)),
                ('value', models.TextField()),
                ('job_group', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='job_param', to='jobs.JobGroup')),
            ],
        ),
        migrations.AlterUniqueTogether(
            name='jobparameter',
            unique_together=set([('job_group', 'name')]),
        ),
        migrations.AlterField(
            model_name='job',
            name='store',
            field=models.CharField(db_index=True, max_length=40),
        ),
        migrations.AlterField(
            model_name='jobgroup',
            name='job_type',
            field=models.CharField(db_index=True, max_length=100),
        ),
        migrations.AlterField(
            model_name='jobparameter',
            name='name',
            field=models.CharField(db_index=True, max_length=100),
        ),
        migrations.AlterField(
            model_name='jobparameter',
            name='value',
            field=models.TextField(),
        ),
        migrations.AlterUniqueTogether(
            name='service',
            unique_together=set([('service_name', 'server_type')]),
        ),
        migrations.AlterField(
            model_name='job',
            name='state',
            field=models.CharField(choices=[('P', 'Pending'), ('A', 'Active'), ('C', 'Completed'), ('F', 'Failed')], db_index=True, default='P', max_length=1),
        ),
        migrations.AlterField(
            model_name='jobgroup',
            name='created_date',
            field=models.DateTimeField(auto_now_add=True, db_index=True),
        ),
        migrations.AlterField(
            model_name='jobgroup',
            name='queued_date',
            field=models.DateTimeField(db_index=True, null=True),
        ),
        migrations.AlterField(
            model_name='job',
            name='start_date',
            field=models.DateTimeField(db_index=True, null=True),
        ),
        migrations.AlterField(
            model_name='job',
            name='state',
            field=models.CharField(choices=[('P', 'Pending'), ('A', 'Active'), ('C', 'Completed'), ('F', 'Failed')], default='P', max_length=1),
        ),
        migrations.AlterField(
            model_name='job',
            name='state',
            field=models.CharField(choices=[('P', 'Pending'), ('A', 'Active'), ('C', 'Completed'), ('F', 'Failed')], db_index=True, default='P', max_length=1),
        ),
    ]
