from django import forms
from django.contrib import admin
from django.core.validators import RegexValidator
from django.contrib.auth.forms import UserCreationForm

from myapp.models import CustomUser

class CustomUserCreateForm(UserCreationForm):
    # You can try, but overriding just the form validator will not help you
    username = forms.CharField(label="Custom username", validators=[RegexValidator(r"^[\w\-@']+$")])


class CustomUserAdmin(admin.ModelAdmin):
    form = CustomUserCreateForm

admin.site.register(CustomUser, CustomUserAdmin)