from django.contrib.auth.models import User
from django.core.validators import RegexValidator

class CustomUser(User):
    # Allow apostrophes in usernames
    username_validator = RegexValidator(r"^[\w\-@']+$")

    class Meta:
        proxy = True 

    # This is one way to fix it, but it's hacky:
    # 
    # def __init__(self, *args, **kwargs):
    #     super(CustomUser, self).__init__(*args, **kwargs)
    #     self._meta.get_field('username').validators = [RegexValidator(r"^[\w\-@']+$")]



