from .models import A, B, C, D
from django.http.response import HttpResponse
from django.db.models import Prefetch


def setup():
    a = A.objects.create()
    b = B.objects.create()
    d = D.objects.create()

    b.a = a
    b.save()

    C.objects.create(b=b, d=d)


def nested_prefetch(request, *args, **kwargs):
    setup()
    queryset = A.objects.all().prefetch_related(
        Prefetch(
            'b',
            queryset=B.objects.all().prefetch_related(
                Prefetch(
                    'c',
                    queryset=C.objects.all().prefetch_related(
                        'd'
                    )
                )
            )
        )
    )
    content = queryset[0].b.c.all()[0].d.pk
    return HttpResponse(content)


def flat_prefetch(request, *args, **kwargs):
    setup()
    queryset = A.objects.all().prefetch_related(
        Prefetch(
            'b',
            queryset=B.objects.all().prefetch_related(
                Prefetch('c__d')
            )
        )
    )
    content = queryset[0].b.c.all()[0].d.pk
    return HttpResponse(content)
