from dal import autocomplete

from django.views.generic import CreateView

from .forms import MyModelCreateForm
from .models import MyModel, MyOtherModel

class CreateMyModelView(CreateView):
    template_name = 'create_my_model.html'
    success_url = 'admin/'
    model = MyModel

    def get_form_class(self):
        return MyModelCreateForm

class AutocompleteView(autocomplete.Select2QuerySetView):
    def get_queryset(self):
        queryset = MyOtherModel.objects.all()
        if self.q:
            queryset = queryset.filter(foo__contains=self.q)
        print('This is what the autocomplete view sees:' + str(queryset)) #this is for debugging
        return queryset
