from __future__ import unicode_literals

from django.db import models

class Foo(models.Model):

    a = models.CharField(max_length=10)
    b = models.CharField(max_length=10)
    parent = models.ForeignKey(
        "self", related_name="children", null=True, blank=True)

class Bar(models.Model):

    a = models.CharField(max_length=10)
    _b = models.CharField(max_length=10, name="b", db_column="b")
    parent = models.ForeignKey(
        "self", related_name="children", null=True, blank=True)

    @property
    def b(self):
        return self._b

    @b.setter
    def b(self, val):
        print "SETTING B"
        # This would make the problem disappear:
        # self.__dict__["b"] = val
        self._b = val
