from django.db import models
from django.contrib.auth.models import User


class Department(models.Model):
    code = models.CharField(max_length=4, unique=True)
    description = models.CharField(max_length=50, blank=True, null=True)

class Somebody(models.Model):
    user = models.OneToOneField(User)
    department = models.ForeignKey(Department, models.CASCADE, to_field="code", null=True, blank=True)

class Profile(models.Model):  # we want an admin for this and filter on related data!
    who = models.OneToOneField(Somebody)

class ClientInfo(models.Model):
    who = models.OneToOneField(Somebody)
    filter_by_me_please = models.CharField(db_index=True, max_length=20, blank=True)
