"""Test script to reproduce a bug with RequestContext."""

from django.test import RequestFactory
from django.template.backends.django import DjangoTemplates
from django.template import Template, RequestContext


# a simple template
TEMPLATE_STRING = '{{ name }}'

# a simple context_processer
def processor_add_name(request):
    return {'name': 'foo'}

# Django template engine
ENGINE = DjangoTemplates({
    'DIRS': [], 'APP_DIRS': False,
    'NAME': 'django',
    'OPTIONS': {
        'context_processors': [processor_add_name],
    },
})


# testing functions, see run_tests() below
def test_base_template():
    request = RequestFactory().get('/')
    template = Template(TEMPLATE_STRING)
    context = RequestContext(request, {}, [processor_add_name])
    return template.render(context)

def test_django_template():
    request = RequestFactory().get('/')
    template = ENGINE.from_string(TEMPLATE_STRING)
    context = RequestContext(request, {})
    return template.render(context)

def test_django_template_explicit_processors():
    request = RequestFactory().get('/')
    template = ENGINE.from_string(TEMPLATE_STRING)
    context = RequestContext(request, {}, [processor_add_name])
    return template.render(context)


def run_tests():
    assert test_base_template() == 'foo'
    # The next two fail, both functions return '' (empty string).
    assert test_django_template() == 'foo'
    assert test_django_template_explicit_processors() == 'foo'
