from engine.models import Template, Link, Placeholder, ShipmentData, Domain
from lxml import etree
import base64, os
from mailinglist import settings

class MailingListTemplateParser():
	"""
	Classe che recupera i link e i placeholder
	"""
	template_id = -1
	new_doc = None
	placeholder_tag = "ph"
	
	
	def __init__(self, template_id):
		self.template_id = template_id
		
		
	def link_exists(self, attrib):
		href = attrib["href"]
		category = attrib["category"] if ("category" in attrib) else ""
		name = attrib["name"] if ("name" in attrib) else ""
		tmp = Link.objects.filter(original = href, template_id = self.template_id)
		if (len(tmp) > 0):
			return tmp[0]
		else:
			return Link()
		# return Link.objects.get_or_create(original = href, category = category, name = name, template_id = self.template_id)
	
	
	def placeholder_exists(self, attrib):
		name = attrib["name"]
		# tmp = Placeholder.objects.filter(name = name, template_id = self.template_id)
		tmp = Placeholder.objects.filter(template_id = self.template_id)
		if (len(tmp) > 0):
			return tmp[0]
		else:
			return Placeholder()
		# return Placeholder.objects.get_or_create(name = name, template_id = self.template_id)
		
		
	def start(self, tag, attrib):
		if (tag == "a"):
			l = self.link_exists(attrib)
			# l = Link()
			l.template_id = self.template_id
			l.original = attrib["href"]
			l.destination = attrib["href"]
			if ("category" in attrib):
				l.category = attrib["category"]
			if ("name" in attrib):
				l.name = attrib["name"]
			l.save()
			
		if (tag == self.placeholder_tag):
			if ("name" in attrib):
				p = self.placeholder_exists(attrib)
				# p = Placeholder()
				p.template_id = self.template_id
				p.name = attrib["name"]
				p.save()
				
	
	def end(self, tag):
		pass
	
	
	def data(self, data):
		pass
	
	
	def comment(self, text):
		pass
	
	
	def close(self):
		pass


class TemplateUtility():
	"""
	Classe per la gestione dei template:
	"""
	template_id = -1
	template_file = None
	template_file_path = ""
	placeholder_tag = "ph"
	
	# TODO : rivedere il tutto con un costruttore senza template_id
	
	def __init__(self, template_id):
		self.template_id = template_id
		template_files = Template.objects.filter(id = template_id)
		if (template_files is not None and len(template_files)>0):
			self.template_file = template_files[0]
			self.template_file_path = os.path.join(settings.MEDIA_ROOT, self.template_file.path.name)
	
	def parse(self):
		if (self.template_id > 0 and self.template_file is not None):
			parser_instance = MailingListTemplateParser(self.template_id)
			parser = etree.HTMLParser(target = parser_instance)
			f = open(self.template_file_path, "r")
			s = f.read()
			f.close()
			parser.feed(s)
	
	
	def get_remote_template(self, src):
		# TODO : implementare il download del template da un sito remoto
		pass
	
	
	def create_mail(self, shipment_id, recipient_id):
		"""
		Crea il testo di una mail a partire da:
		 a) template
		 b) dati dell'invio relativi al destinatario
		 c) modifica i link. Codice = base64(base64(url) | recipient_id | shipment_id | link_id)
		"""
		mail = ""
		if (self.template_file is not None):
			try:
				template_file = open(self.template_file_path, "r")
			except:
				template_file = open(os.path.join(settings.MEDIA_ROOT, self.template_file_path))
			template_content = template_file.read()
			template_file.close()
			
			# recupero i dati da sostituire e altre info di supporto
			shipment_data = ShipmentData.objects.filter(recipient_id = recipient_id, shipment_id = shipment_id)
			domain = Domain.objects.filter(channel__shipment__id = shipment_id)[0].domain
			links = Link.objects.filter(template_id = self.template_file.id)
			
			# sostituisco i placeholder e i link
			parser = etree.HTMLPullParser()
			parser.feed(template_content)
			events = parser.read_events()
			
			for action, element in events:
				# placeholder
				if (element.tag == self.placeholder_tag and "name" in element.attrib):
					key = element.attrib["name"]
					value = shipment_data.filter(field = key)
					if (value is not None and len(value)>0):
						new_element = etree.Element("v")
						new_element.text = value[0].value
						element.getparent().replace(element, new_element)
						
				#link
				if (element.tag == "a"):
					href = element.attrib["href"]
					if (href[:7] != "mailto:"):
						# preparo i dati per lo short url
						category = element.attrib["category"] if ("category" in element.attrib) else ""
						name = element.attrib["name"] if ("name" in element.attrib) else ""
						link = links.filter(original = href, name = name, category = category)
						link_id = link[0].id if (len(link)>0) else -1
						param = str(base64.b64encode(bytes(href,"utf-8")),"utf-8")
						param = str(base64.b64encode(bytes(param + "|" + str(recipient_id) + "|" + str(shipment_id) + "|" + str(link_id), "utf-8")), "utf-8")
							
						new_href = "http://%s.%s/command/goto/%s" % (domain, settings.NL_TLD, param)
						new_attrib = element.attrib
						new_attrib["href"] = new_href
						new_element = etree.Element("a", new_attrib)
						for child in element.getchildren():
							new_element.append(child)
						new_element.text = element.text
						element.getparent().replace(element, new_element)
					
					
			root = parser.close()
			mail = str(etree.tostring(root),"utf-8")
		return mail
				
		
		