def get_sequence_name(cursor, table_name, pk_name):
    """Fetch the sequence name of an auto-incrementing field

    Uses the postgres native "information_schema.columns" table,
    resulting in a string looking like "nextval('sometable_id_seq'::regclass)"
    """
    query = """SELECT column_default
        FROM information_schema.columns
        WHERE table_name = %s AND column_name = %s;"""
    cursor.execute(query, (table_name, pk_name))
    result = cursor.fetchone()
    if result is None:
        return None
    return result[0].split("'")[1]
