# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations
from django.conf import settings


def upgrade(apps, schema_editor):
    User = apps.get_model(settings.AUTH_USER_MODEL)
    University = apps.get_model('profiles', 'University')
    UserProfile = apps.get_model('profiles', 'UserProfile')
    Post = apps.get_model('posts', 'Post')

    user = User.objects.create(email='example@test.com')
    uni = University.objects.create(name='Example university')
    Post.objects.create(content='Example content', author=user)
    UserProfile.objects.create(user=user, university=uni)


def downgrade(apps, schema_editor):
    pass


class Migration(migrations.Migration):

    dependencies = [
        ('profiles', '0001_initial'),
        ('posts', '0001_initial'),
    ]

    operations = [
        migrations.RunPython(upgrade, downgrade),
    ]
