from django.apps import AppConfig
from django.db.models import signals


def listener(sender, **kwargs):
    from .models import Choice
    assert Choice.objects.get().question is None


class T26630Config(AppConfig):
    name = 't26630'

    def ready(self):
        Question = self.get_model('Question')
        signals.post_delete.connect(listener, sender=Question)
