from django.db import models


class BookInstance(models.Model):
    someattr = models.CharField(max_length=13, blank=True)


class Contract(models.Model):
    listing = models.OneToOneField('Listing', related_name="contract", null=True, blank=True, default=None)
    handoffdate = models.DateTimeField(null=True, blank=True, default=None)
    returndate = models.DateTimeField(null=True, blank=True, default=None)


class AgentAgreement(models.Model):
    book = models.ForeignKey(BookInstance, related_name='delegation')


class Listing(models.Model):
    book_instance = models.ForeignKey(BookInstance, related_name='listings')
