import datetime

from django.db import models

class Customer(models.Model):
    pass

# Create your models here.
class Invoice(models.Model):
    customer = models.ForeignKey(Customer)

    date_created = models.DateField(default=datetime.date.today, db_index=True)
    date_sent = models.DateField(null=True, blank=True)
    date_due = models.DateField(null=True, blank=True)
    date_paid = models.DateField(null=True, blank=True)
    date_credited = models.DateField(null=True, blank=True)
    date_collect = models.DateField(null=True, blank=True)

    invoice_type = models.CharField(default="invoice", max_length=32)

    reminders = models.ManyToManyField("Invoice", related_name="reminded_set", blank=True)
    reminder_counter = models.IntegerField(null=True, blank=True)
