import datetime
import django
if hasattr(django, "setup"):
    django.setup()

from django.db.models import Q

from combinebug.models import Invoice

date = datetime.datetime.now()

invoices = Invoice.objects.filter(
    Q(date_created__lte=date),
    Q(date_paid__gt=date) | Q(date_paid=None),
    Q(date_credited__gt=date) | Q(date_credited=None),
    customer=1,
)

filtered_invoices = Invoice.objects.none()

not_due = Q(date_due__gte=date) | Q(date_due=None)
not_reminded_yet = ~Q(reminders__date_created__lte=date)
not_collected = Q(date_collect__gt=date) | Q(date_collect=None)

filtered_invoices |= invoices.filter(not_due, not_collected, date_sent__lte=date, invoice_type="invoice")

filtered_invoices |= invoices.filter(not_collected, not_reminded_yet, date_sent__lte=date, date_due__lt=date, invoice_type="invoice")

for r in [1, 2, 3]:
    qs = invoices.filter(not_collected, reminders__date_created__lte=date, reminders__reminder_counter=r, invoice_type="invoice")
    for i in range(r + 1, 3 + 1):
        qs = qs.filter(~Q(reminders__reminder_counter=i) | Q(reminders__reminder_counter=i, reminders__date_created__gt=date))
    filtered_invoices |= qs

print("didn't crash")
