from django.db import models
from django.test import TestCase


class MyModel(models.Model):
    pass


class CaseStatemenetEmptyListTestCase(TestCase):
    """Test that annotation doesn't change the count of items in a queryset when
    calling `__in=[]` in a When expression inside a Case exporession in the
    annotation.
    """
    
    def setUp(self):
        for i in range(3):
            MyModel().save()
    
    def test_full_list(self):
        ids = [1, 2, 3]
        qs = MyModel.objects.all()
        count_before = qs.count()
        qs = qs.annotate(
            field=models.Case(
                models.When(id__in=ids, then=models.Value(True)),
                default=models.Value(False),
                output_field=models.BooleanField()
            )
        )
        count_after = qs.count()
        
        self.assertEqual(count_before, count_after)
    
    def test_empty_lsit(self):
        ids = []
        qs = MyModel.objects.all()
        count_before = qs.count()
        qs = qs.annotate(
            field=models.Case(
                models.When(id__in=ids, then=models.Value(True)),
                default=models.Value(False),
                output_field=models.BooleanField()
            )
        )
        count_after = qs.count()
        
        self.assertEqual(count_before, count_after)
    
    def test_empty_qs(self):
        empty_qs = MyModel.objects.none()
        qs = MyModel.objects.all()
        count_before = qs.count()
        qs = qs.annotate(
            field=models.Case(
                models.When(id__in=empty_qs, then=models.Value(True)),
                default=models.Value(False),
                output_field=models.BooleanField()
            )
        )
        count_after = qs.count()
        
        self.assertEqual(count_before, count_after)
    
    def test_empty_lsit_query_raises_exception(self):
        ids = []
        qs = MyModel.objects.all()
        qs = qs.annotate(
            field=models.Case(
                models.When(id__in=ids, then=models.Value(True)),
                default=models.Value(False),
                output_field=models.BooleanField()
            )
        )
        
        with self.assertRaises(models.sql.datastructures.EmptyResultSet):
            str(qs.query)
