#!/usr/bin/env python
import sys, timing
from joetest.foo.models import Thing
from joetest.foo.models import Owner
from django.core import management
from django.contrib.auth.create_superuser import createsuperuser
from django.utils.datastructures import MultiValueDict
import random

def makeThing(intvalue):
    thing_maker = Thing.AddManipulator()
    new_thing_data = MultiValueDict()
    new_thing_data['name'] = "%d - %f - %f" % (intvalue,random.random(),random.random())
    errors = thing_maker.get_validation_errors(new_thing_data)
    if not errors:
        thing_maker.do_html2python(new_thing_data)
        new_thing = thing_maker.save(new_thing_data)
        return new_thing
    else:
        print "Errors creating Thing: %s" % errors

def makeOwner(intvalue):
    owner_maker = Owner.AddManipulator()
    new_owner_data = MultiValueDict()
    new_owner_data['name'] = "%d - %f - %f" % (intvalue,random.random(),random.random())
    new_owner_data['thing'] = "%d" % intvalue
    errors = owner_maker.get_validation_errors(new_owner_data)
    if not errors:
        owner_maker.do_html2python(new_owner_data)
        new_owner = owner_maker.save(new_owner_data)
        return new_owner
    else:
        print "Errors creating Thing: %s" % errors
    
        
management.syncdb() 
createsuperuser('heckj','all@trenchmice.com','eojcc')

print "making 20,000 new things"
for i in range(1,3001):
    timing.start()
    new_thing = makeThing(i)
    timing.finish()
    #print "thing : time", float(timing.micro())/1000000," %s" % (new_thing.id,)

#for i in range(1,20000):
    timing.start()
    new_owner = makeOwner(i)
    timing.finish()
    if i % 100 == 0:
        print "owner : time", float(timing.micro())/1000000," %s" % (new_owner.id)
